/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.botania.alfheim;

import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class AlfheimNoise {
    public final long seed;
    private final double[] randomSource;
    private static int XSEED = 1619;
    private static int ZSEED = 31337;
    private static int NSEED = 1013;
    private static int NSHIFT = 8;

    public AlfheimNoise(long seed) {
        this.seed = seed;
        this.randomSource = new double[512];
        Random randy = new Random(this.seed);
        for (int i = 0; i < 256; ++i) {
            double r = randy.nextDouble();
            double a = randy.nextDouble() * 2.0 * Math.PI;
            this.randomSource[i * 2] = Math.sin(a) * r;
            this.randomSource[i * 2 + 1] = Math.cos(a) * r;
        }
    }

    private double getNoise(double x, double z, double period, long seed) {
        double frequency = period == 0.0 ? 1.0 : 1.0 / period;
        return this.calcNoise(x * frequency, z * frequency, seed);
    }

    private double calcNoise(double x, double z, long seed) {
        int x0 = x > 0.0 ? MathHelper.func_76128_c((double)x) : MathHelper.func_76128_c((double)x) - 1;
        int x1 = x0 + 1;
        int z0 = z > 0.0 ? MathHelper.func_76128_c((double)z) : MathHelper.func_76128_c((double)z) - 1;
        int z1 = z0 + 1;
        double xs = this.deriv1(x - (double)x0);
        double zs = this.deriv1(z - (double)z0);
        double tl = this.gradientNoise(x, z, x0, z0, seed);
        double tr = this.gradientNoise(x, z, x1, z0, seed);
        double top = this.lerp(tl, tr, xs);
        double bl = this.gradientNoise(x, z, x0, z1, seed);
        double br = this.gradientNoise(x, z, x1, z1, seed);
        double bot = this.lerp(bl, br, xs);
        return this.lerp(top, bot, zs);
    }

    private double gradientNoise(double fx, double fz, int ix, int iz, long seed) {
        Vec3 grad = this.getGradient(ix, iz, seed);
        Vec3 point = Vec3.func_72443_a((double)(fx - (double)ix), (double)(fz - (double)iz), (double)0.0);
        return grad.func_72430_b(point) * 2.12;
    }

    private Vec3 getGradient(int x, int z, long seed) {
        long vectorindex = (long)(XSEED * x + ZSEED * z) + (long)NSEED * seed & 0xFFFFFFFFFFFFFFFFL;
        vectorindex ^= vectorindex >> NSHIFT;
        int vi = (int)(vectorindex &= 0xFFL);
        return Vec3.func_72443_a((double)this.randomSource[vi * 2], (double)this.randomSource[vi * 2 + 1], (double)0.0);
    }

    private Vec3 calcDerivative(double x, double z, long seed) {
        int ix = MathHelper.func_76128_c((double)x);
        int iz = MathHelper.func_76128_c((double)z);
        double fx = x - (double)ix;
        double fz = z - (double)iz;
        double wx = this.deriv1(fx);
        double wz = this.deriv1(fz);
        double dwx = this.deriv2(fx);
        double dwz = this.deriv2(fz);
        double dwpx = this.deriv3(fx);
        double dwpz = this.deriv3(fz);
        Vec3 vtl = this.getGradient(ix, iz, seed);
        Vec3 vtr = this.getGradient(ix + 1, iz, seed);
        Vec3 vbl = this.getGradient(ix, iz + 1, seed);
        Vec3 vbr = this.getGradient(ix + 1, iz + 1, seed);
        double tl = vtl.field_72450_a * (x - (double)ix) + vtl.field_72448_b * (z - (double)iz);
        double tr = vtr.field_72450_a * (x - (double)(ix + 1)) + vtr.field_72448_b * (z - (double)iz);
        double bl = vbl.field_72450_a * (x - (double)ix) + vbl.field_72448_b * (z - (double)(iz + 1));
        double br = vbr.field_72450_a * (x - (double)(ix + 1)) + vbr.field_72448_b * (z - (double)(iz + 1));
        double top = this.lerp(tl, tr, wx);
        double bot = this.lerp(bl, br, wx);
        double n = this.lerp(top, bot, wz);
        double dx = vtl.field_72450_a + (vbl.field_72450_a - vtl.field_72450_a) * wz + ((vtr.field_72448_b - vtl.field_72448_b) * fz - vtr.field_72450_a + ((vtl.field_72448_b - vtr.field_72448_b - vbl.field_72448_b + vbr.field_72448_b) * fz + vtr.field_72450_a + vbl.field_72448_b - vbr.field_72450_a - vbr.field_72448_b) * wz) * dwx + (vtr.field_72450_a - vtl.field_72450_a + (vtl.field_72450_a - vtr.field_72450_a - vbl.field_72450_a + vbr.field_72450_a) * wz) * dwpx;
        double dz = vtl.field_72448_b + (vtr.field_72448_b - vtl.field_72448_b) * wx + ((vbl.field_72450_a - vtl.field_72450_a) * fx - vbl.field_72448_b + ((vtl.field_72450_a - vtr.field_72450_a - vbl.field_72450_a + vbr.field_72450_a) * fx + vtr.field_72450_a + vbl.field_72448_b - vbr.field_72450_a - vbr.field_72448_b) * wx) * dwz + (vbl.field_72448_b - vtl.field_72448_b + (vtl.field_72448_b - vtr.field_72448_b - vbl.field_72448_b + vbr.field_72448_b) * wx) * dwpz;
        return Vec3.func_72443_a((double)(n * 2.0), (double)(dx * 2.0), (double)(dz * 2.0));
    }

    private double getNoiseOctaves(double x, double z, int octaves, double period, double lacunarity, double gain, long seed) {
        double sum = 0.0;
        double freq = period == 0.0 ? 1.0 : 1.0 / period;
        double amp = 1.0;
        for (int i = 0; i < octaves; ++i) {
            double n = this.getNoise(x, z, period * (double)i, seed + (long)i);
            sum += n * amp;
            freq *= lacunarity;
            amp *= gain;
        }
        return sum;
    }

    private double getJordanRaw(double x, double z, int octaves, double period, double lacunarity, double gain0, double gain, double warp0, double warp, double damp0, double damp, double dampscale, long seed) {
        double amp = gain0;
        double freq = (period == 0.0 ? 1.0 : 1.0 / period) * lacunarity;
        double damped_amp = amp * gain;
        Vec3 n = this.calcDerivative(x * freq, z * freq, seed);
        Vec3 n2 = Vec3.func_72443_a((double)(n.field_72450_a * n.field_72450_a), (double)(n.field_72448_b * n.field_72450_a), (double)(n.field_72449_c * n.field_72450_a));
        double sum = n2.field_72450_a;
        double dswx = n2.field_72448_b * warp0;
        double dswz = n2.field_72449_c * warp0;
        double dsdx = n2.field_72448_b * damp0;
        double dsdz = n2.field_72449_c * damp0;
        for (int i = 1; i < octaves; ++i) {
            n = this.calcDerivative(x * freq + dswx, z * freq + dswz, seed + (long)i);
            n2 = Vec3.func_72443_a((double)(n.field_72450_a * n.field_72450_a), (double)(n.field_72448_b * n.field_72450_a), (double)(n.field_72449_c * n.field_72450_a));
            sum += damped_amp * (n2.field_72450_a * 1.5 + 0.1);
            dswx += n2.field_72448_b * warp;
            dswz += n2.field_72449_c * warp;
            freq *= lacunarity;
            double dsddot = (dsdx += n2.field_72448_b * damp) * dsdx + (dsdz += n2.field_72449_c * damp) * dsdz;
            damped_amp = (amp *= gain) * (1.0 - dampscale / (1.0 + dsddot));
        }
        return sum;
    }

    public double getJordan(double x, double z, int octaves, double period, double lacunarity, double gain0, double gain, double warp0, double warp, double damp0, double damp, double dampscale, int distortionoctaves, double distortionscale, double distortion, double distortiongain, long seed) {
        x += this.getNoiseOctaves(x, z, distortionoctaves, period * distortionscale, lacunarity, distortiongain, seed + 1L) * distortion * period * distortionscale;
        z += this.getNoiseOctaves(x, z, distortionoctaves, period * distortionscale, lacunarity, distortiongain, seed + 2L) * distortion * period * distortionscale;
        return this.getJordanRaw(x, z, octaves, period, lacunarity, gain0, gain, warp0, warp, damp0, damp, dampscale, seed);
    }

    public double getJordanDefault(double x, double z) {
        return this.getJordan(x, z, 4, 750.0, 4.0, 0.9, 0.7, 0.8, 0.6, 1.0, 0.8, 1.0, 1, 0.001, 0.35, 0.5, this.seed);
    }

    private double deriv1(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private double deriv2(double n) {
        return n * n * (n * (n * 30.0 - 60.0) + 30.0);
    }

    private double deriv3(double n) {
        return n * n * n * (n * (n * 36.0 - 75.0) + 40.0);
    }

    private double lerp(double a, double b, double n) {
        return a * (1.0 - n) + b * n;
    }
}

