/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.botania.alfheim;

import fox.spiteful.avaritia.compat.botania.alfheim.ComponentCityParts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenCity
extends MapGenStructure {
    public MapGenCity() {
        this.field_75040_a = (int)Math.ceil(37.0);
    }

    public String func_143025_a() {
        return "AlfCity";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return chunkX == 0 && chunkZ == 0;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        protected int CITYRADIUS;
        protected int ROADSIZE = 8;
        protected int BLOCKSIZE = 24;
        protected int BLOCKS;

        public Start() {
        }

        public Start(World world, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.CITYRADIUS = 600;
            this.BLOCKS = MathHelper.func_76128_c((double)((double)(this.CITYRADIUS * 2 + this.ROADSIZE) / (double)(this.BLOCKSIZE + this.ROADSIZE)));
            if (this.BLOCKS % 2 != 0) {
                --this.BLOCKS;
            }
            int blockwidth = this.BLOCKS * this.BLOCKSIZE + (this.BLOCKS - 1) * this.ROADSIZE;
            int origin = -blockwidth / 2;
            ArrayList<ChunkCoordinates> cells = new ArrayList<ChunkCoordinates>();
            int[] cellfill = new int[this.BLOCKS * this.BLOCKS];
            for (int i = 0; i < cellfill.length; ++i) {
                cellfill[i] = 0;
            }
            for (int bx = 0; bx < this.BLOCKS; ++bx) {
                for (int bz = 0; bz < this.BLOCKS; ++bz) {
                    int z;
                    double cz;
                    int x;
                    double cx;
                    double rad;
                    if (bx > this.BLOCKS / 2 - 3 && bx < this.BLOCKS / 2 + 2 && bz > this.BLOCKS / 2 - 3 && bz < this.BLOCKS / 2 + 2 || !((rad = Math.sqrt((cx = (double)(x = origin + (this.BLOCKSIZE + this.ROADSIZE) * bx) + (double)this.BLOCKSIZE * 0.5) * cx + (cz = (double)(z = origin + (this.BLOCKSIZE + this.ROADSIZE) * bz) + (double)this.BLOCKSIZE * 0.5) * cz) / ((double)this.CITYRADIUS - (double)this.BLOCKSIZE * 0.75)) < 1.0) || !(rand.nextDouble() > rad - 0.4)) continue;
                    cells.add(new ChunkCoordinates(bx, bz, 0));
                    cellfill[bz * this.BLOCKS + bx] = 1;
                }
            }
            Collections.shuffle(cells);
            while (cells.size() > 0) {
                ChunkCoordinates cell = (ChunkCoordinates)cells.remove(0);
                int bz = cell.field_71572_b;
                int bx = cell.field_71574_a;
                int index = bz * this.BLOCKS + bx;
                if (cellfill[index] != 1) continue;
                int dx = this.BLOCKS / 2 - bx;
                int dz = this.BLOCKS / 2 - bz;
                double dist = Math.sqrt(dx * dx + dz * dz) / ((double)this.BLOCKS * 0.5);
                int width = 1;
                int height = 1;
                if (rand.nextDouble() < 1.5 * (1.0 - dist) - 0.05) {
                    ++width;
                    ++height;
                    if (rand.nextDouble() < 0.1) {
                        ++width;
                    }
                    if (rand.nextDouble() < 0.1) {
                        ++height;
                    }
                }
                while (width != 1 || height != 1) {
                    boolean ok = true;
                    block5: for (int cx = 0; cx < width; ++cx) {
                        for (int cz = 0; cz < height; ++cz) {
                            if (bx + cx >= this.BLOCKS || bz + cz >= this.BLOCKS) {
                                ok = false;
                                continue block5;
                            }
                            if (bx < this.BLOCKS / 2 && bx + cx >= this.BLOCKS / 2 || bz < this.BLOCKS / 2 && bz + cz >= this.BLOCKS / 2) {
                                ok = false;
                                continue block5;
                            }
                            int cindex = (bz + cz) * this.BLOCKS + (bx + cx);
                            if (cellfill[cindex] == 1) continue;
                            ok = false;
                            continue block5;
                        }
                    }
                    if (ok) break;
                    if (width > 1 && height > 1) {
                        if (rand.nextBoolean()) {
                            --width;
                            continue;
                        }
                        --height;
                        continue;
                    }
                    if (width > 1) {
                        --width;
                        continue;
                    }
                    --height;
                }
                for (int cx = 0; cx < width; ++cx) {
                    for (int cz = 0; cz < height; ++cz) {
                        int cindex = (bz + cz) * this.BLOCKS + (bx + cx);
                        cellfill[cindex] = 2;
                    }
                }
                double size = Math.sqrt(width * height);
                int floors = (int)Math.round(0.5 + size * 1.45 * (1.0 - dist + 0.3) * (rand.nextDouble() * rand.nextDouble()) + rand.nextDouble() * (1.0 - dist) * 0.6 + rand.nextDouble() * 0.2);
                int x = origin + (this.BLOCKSIZE + this.ROADSIZE) * bx;
                int z = origin + (this.BLOCKSIZE + this.ROADSIZE) * bz;
                int structurewidth = width * this.BLOCKSIZE + (width - 1) * this.ROADSIZE;
                int structureheight = height * this.BLOCKSIZE + (height - 1) * this.ROADSIZE;
                ComponentCityParts.CityRuin ruin = new ComponentCityParts.CityRuin(rand, x, z, structurewidth, structureheight, floors);
                this.field_75075_a.add(ruin);
            }
            this.func_75072_c();
        }
    }
}

