/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.forestry;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import net.minecraft.util.StatCollector;

public enum BeeBranch implements IClassification
{
    BALANCED("balanced", "Molestus"),
    INFINITE("infinite", "Infinitus");

    private String name;
    private String latin;
    private ArrayList<IAlleleSpecies> species = new ArrayList();
    private IClassification parent;
    private final IClassification.EnumClassLevel level = IClassification.EnumClassLevel.GENUS;

    private BeeBranch(String nombre, String science) {
        this.name = nombre;
        this.latin = science;
        this.parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
        AlleleManager.alleleRegistry.registerClassification((IClassification)this);
    }

    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    public String getUID() {
        return "classification." + this.name;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("classification." + this.name));
    }

    public String getScientific() {
        return this.latin;
    }

    public String getDescription() {
        return StatCollector.func_74838_a((String)("classification." + this.name + ".desc"));
    }

    public IClassification[] getMemberGroups() {
        return null;
    }

    public void addMemberGroup(IClassification group) {
    }

    public IAlleleSpecies[] getMemberSpecies() {
        return this.species.toArray(new IAlleleSpecies[this.species.size()]);
    }

    public void addMemberSpecies(IAlleleSpecies species) {
        if (!this.species.contains(species)) {
            this.species.add(species);
        }
    }

    public IClassification getParent() {
        return this.parent;
    }

    public void setParent(IClassification parent) {
        this.parent = parent;
    }
}

