/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml;

import by.fxg.basicfml.FMLScheduler;
import by.fxg.basicfml.ThreadTask;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.math.NumberUtils;
import org.yaml.snakeyaml.Yaml;

public class BasicFML {
    private static final Pattern TIME_FORMAT_REGEX = Pattern.compile("([0-9]+)(ms|milli(?:s(?:econds?)?)?|t(?:icks?)?|s(?:ec(?:onds?)?)?|m(?:in(?:utes?)?)?|h(?:ours?)?|d(?:ays?)?|w(?:eeks?)?|)", 2);
    public static final Logger LOGGER = Logger.getLogger("BasicFML");
    public static final Gson GSON_INSTANCE = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    public static final Yaml YAML_INSTANCE = new Yaml();
    private static BasicFML INSTANCE;
    private Map<TickEvent.Type, List<FMLScheduler>> activeSchedulers = new HashMap<TickEvent.Type, List<FMLScheduler>>();

    public static BasicFML instance() {
        return INSTANCE != null ? INSTANCE : new BasicFML();
    }

    public static FMLScheduler runTickTask(TickEvent.Type type, TickEvent.Phase phase, Consumer<FMLScheduler> task, long ticks) {
        Objects.requireNonNull(type, "TickEvent.Type can't be null");
        Objects.requireNonNull(task, "Can't create scheduler with null task consumer");
        FMLScheduler scheduler = new FMLScheduler(type, phase != null ? phase : TickEvent.Phase.END, task, ticks);
        BasicFML.instance().activeSchedulers.get(type).add(scheduler);
        return scheduler;
    }

    public static FMLScheduler runTickTask(TickEvent.Type type, Consumer<FMLScheduler> task, long ticks) {
        return BasicFML.runTickTask(type, TickEvent.Phase.END, task, ticks);
    }

    public static boolean stopTask(FMLScheduler scheduler) {
        return scheduler != null ? BasicFML.instance().activeSchedulers.get(scheduler.tickType).remove(scheduler) : false;
    }

    public static void runAsyncTask(Runnable runnable, long delay) {
        ThreadTask task = new ThreadTask(runnable, delay);
        task.start();
    }

    public static void registerEventAndGameHandler(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
        FMLCommonHandler.instance().bus().register(object);
    }

    public static void unregisterEventAndGameHandler(Object object) {
        MinecraftForge.EVENT_BUS.unregister(object);
        FMLCommonHandler.instance().bus().unregister(object);
    }

    public static ItemStack resolveItemStack(String str) {
        try {
            if (str.contains("<") && str.contains(">")) {
                String[] objects;
                String input = str.replaceAll("\\s+", "");
                int start = input.indexOf(60);
                int end = input.indexOf(62);
                if (end - start > 1 && (objects = input.substring(start + 1, end).split(":")) != null && objects.length > 1) {
                    String sizeStr;
                    int stackSize = 1;
                    if (input.length() > end && (sizeStr = input.substring(end + 1)).startsWith("*")) {
                        stackSize = NumberUtils.toInt((String)sizeStr.substring(1), (int)stackSize);
                    }
                    ItemStack stack = GameRegistry.findItemStack((String)objects[0], (String)objects[1], (int)stackSize);
                    if (objects.length > 2) {
                        stack.func_77964_b(NumberUtils.toInt((String)objects[2], (int)0));
                    }
                    return stack;
                }
            } else if (str.contains(":")) {
                String[] objects = str.replaceAll("\\s+", "").split(":");
                int stackSize = objects.length > 3 ? NumberUtils.toInt((String)objects[3], (int)1) : 1;
                int meta = objects.length > 2 ? NumberUtils.toInt((String)objects[2], (int)0) : 0;
                ItemStack stack = GameRegistry.findItemStack((String)objects[0], (String)objects[1], (int)stackSize);
                stack.func_77964_b(meta);
                return stack;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String convertItemStackToMineTweakerName(ItemStack stack) {
        if (stack != null) {
            StringBuilder builder = new StringBuilder("<");
            builder.append(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
            if (stack.func_77960_j() != 0) {
                builder.append(":").append(stack.func_77960_j());
            }
            builder.append(">");
            if (stack.field_77994_a > 1) {
                builder.append(" * ").append(stack.field_77994_a);
            }
            return builder.toString();
        }
        return "<null>";
    }

    public static long parseTime(String string, long defaultValue) {
        if (string != null) {
            long time = 0L;
            Matcher matcher = TIME_FORMAT_REGEX.matcher(string.toLowerCase());
            block30: while (matcher.find()) {
                long timeUnit = NumberUtils.toLong((String)matcher.group(1), (long)defaultValue);
                switch (matcher.group(2).toLowerCase()) {
                    case "w": 
                    case "week": 
                    case "weeks": {
                        time += timeUnit * 604800000L;
                        continue block30;
                    }
                    case "d": 
                    case "day": 
                    case "days": {
                        time += timeUnit * 86400000L;
                        continue block30;
                    }
                    case "h": 
                    case "hour": 
                    case "hours": {
                        time += timeUnit * 3600000L;
                        continue block30;
                    }
                    case "m": 
                    case "min": 
                    case "minute": 
                    case "minutes": {
                        time += timeUnit * 60000L;
                        continue block30;
                    }
                    case "s": 
                    case "sec": 
                    case "second": 
                    case "seconds": {
                        time += timeUnit * 1000L;
                        continue block30;
                    }
                    case "t": 
                    case "tick": 
                    case "ticks": {
                        time += timeUnit * 50L;
                        continue block30;
                    }
                }
                time += timeUnit;
            }
            return time;
        }
        return defaultValue;
    }

    public static long parseTicks(String string, long defaultValue) {
        return BasicFML.parseTime(string, defaultValue * 50L) / 50L;
    }

    private BasicFML() {
        INSTANCE = this;
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        Stream.of(TickEvent.Type.values()).forEach(type -> {
            List cfr_ignored_0 = this.activeSchedulers.put((TickEvent.Type)type, new ArrayList());
        });
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        List<FMLScheduler> schedulers = this.activeSchedulers.get(event.type);
        for (int i = 0; i != schedulers.size(); ++i) {
            FMLScheduler scheduler = schedulers.get(i);
            if (scheduler.tickPhase != event.phase) continue;
            scheduler.onTickEvent(event);
        }
    }
}

