/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.io;

import by.fxg.basicfml.BasicFML;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.io.BasicConfigReader;
import by.fxg.basicfml.configv2.io.BasicConfigWriter;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class GsonIntermediaryReadWriter
implements BasicConfigReader<IntermediaryCompound>,
BasicConfigWriter<IntermediaryCompound> {
    private Gson gson;

    public GsonIntermediaryReadWriter(Gson gson) {
        this.gson = gson;
    }

    public GsonIntermediaryReadWriter() {
        this(BasicFML.GSON_INSTANCE);
    }

    @Override
    public boolean write(File file, IntermediaryCompound type) {
        if (file != null) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8));
                writer.write(this.gson.toJson(IntermediaryCompound.convertToMap(type)));
                ((Writer)writer).close();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public IntermediaryCompound read(File file) {
        if (file != null && file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Map table = (Map)this.gson.fromJson((Reader)reader, Map.class);
                ((Reader)reader).close();
                return new IntermediaryCompound(table);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

