/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.io.yaml;

import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public final class YamlWriter {
    private static final String LINE_SEPARATOR_REGEX = "\r\n?|\n";
    private static final String COLON = ":";
    private static final String COMMENT = "# ";
    private static final String COLON_SPACER = ": ";
    private static final String DOUBLE_SPACER = "  ";
    private static final String HYPHEN_SPACER = "- ";
    private final Writer writer;
    private final int indentSize;
    private final char indentCharacter;
    private final String lineSeparator;
    private boolean separateFirstCompounds = true;
    private boolean separateCommentsFromAbove = true;
    private int indentLevel = 0;
    private IntermediaryWrapper lastWritten;

    public YamlWriter(Writer writer) {
        this(writer, 2, false);
    }

    public YamlWriter(Writer writer, int indentSize, boolean useIndentTabs) {
        this(writer, indentSize, useIndentTabs, System.lineSeparator());
    }

    public YamlWriter(Writer writer, int indentSize, boolean useIndentTabs, String lineSeparator) {
        this.writer = writer;
        this.indentSize = indentSize;
        this.indentCharacter = (char)(useIndentTabs ? 9 : 32);
        this.lineSeparator = lineSeparator;
    }

    public void setSeparateFirstCompounds(boolean enable) {
        this.separateFirstCompounds = enable;
    }

    public void setSeparateCommentsFromAbove(boolean enable) {
        this.separateCommentsFromAbove = enable;
    }

    public void write(IntermediaryCompound compound) throws IOException {
        for (Map.Entry<String, IntermediaryWrapper> entry : compound) {
            this.writeWrapper(entry.getKey(), entry.getValue(), true, true);
            if (!this.separateFirstCompounds) continue;
            this.newLineIndent();
        }
    }

    private void writeWrapper(String name, IntermediaryWrapper wrapper, boolean isUnmarked, boolean handleNewLine) throws IOException {
        if (wrapper == null) {
            this.newLineIndent();
            this.lastWritten = null;
            return;
        }
        if (wrapper.hasComment()) {
            this.writeComment(wrapper);
        }
        if (!isUnmarked) {
            this.write(HYPHEN_SPACER);
        }
        if (wrapper instanceof IntermediaryCompound) {
            IntermediaryCompound compound = (IntermediaryCompound)wrapper;
            ++this.indentLevel;
            if (isUnmarked) {
                this.write(name);
                this.write(COLON);
                this.newLineIndent();
            }
            this.lastWritten = wrapper;
            Iterator<Map.Entry<String, IntermediaryWrapper>> iterator = compound.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, IntermediaryWrapper> entry = iterator.next();
                this.writeWrapper(entry.getKey(), entry.getValue(), true, false);
                this.lastWritten = entry.getValue();
                if (iterator.hasNext()) {
                    this.newLineIndent();
                    continue;
                }
                if (!handleNewLine) continue;
                --this.indentLevel;
                this.newLineIndent();
                ++this.indentLevel;
            }
            --this.indentLevel;
            this.lastWritten = wrapper;
        } else if (wrapper instanceof IntermediaryArray) {
            IntermediaryArray array = (IntermediaryArray)wrapper;
            if (array.size() < 1) {
                if (isUnmarked) {
                    this.write(name);
                    this.write(COLON_SPACER);
                }
                this.write("[]");
            } else {
                ++this.indentLevel;
                if (isUnmarked) {
                    this.write(name);
                    this.write(COLON);
                    this.newLineIndent();
                }
                this.lastWritten = wrapper;
                Iterator<IntermediaryWrapper> iterator = array.iterator();
                while (iterator.hasNext()) {
                    IntermediaryWrapper iterable = iterator.next();
                    this.writeWrapper(null, iterable, false, false);
                    this.lastWritten = iterable;
                    if (iterator.hasNext()) {
                        this.newLineIndent();
                        continue;
                    }
                    if (!handleNewLine) continue;
                    --this.indentLevel;
                    this.newLineIndent();
                    ++this.indentLevel;
                }
                --this.indentLevel;
                this.lastWritten = wrapper;
            }
        } else if (wrapper instanceof IntermediaryPrimitive) {
            IntermediaryPrimitive primitive = (IntermediaryPrimitive)wrapper;
            if (isUnmarked) {
                this.write(name);
                this.write(COLON_SPACER);
            }
            if (primitive.isLiteral()) {
                this.write(primitive.getValue() instanceof String ? primitive.getString() : String.valueOf(primitive.getChar()));
            } else if (primitive.isNumber() || primitive.isBoolean()) {
                this.write(primitive.getValue().toString());
            }
            this.lastWritten = wrapper;
            if (handleNewLine) {
                this.newLineIndent();
            }
        }
    }

    private void writeComment(IntermediaryWrapper wrapper) throws IOException {
        String[] commentParts = wrapper.getComment().split(LINE_SEPARATOR_REGEX);
        if (this.separateCommentsFromAbove && commentParts.length > 0 && this.lastWritten != null && !(this.lastWritten instanceof IntermediaryCompound)) {
            this.newLineIndent();
        }
        for (int i = 0; i < commentParts.length; ++i) {
            this.write(COMMENT);
            this.write(commentParts[i]);
            this.newLineIndent();
        }
    }

    private void write(char c) throws IOException {
        this.writer.write(c);
    }

    private void write(String str) throws IOException {
        this.writer.write(str);
    }

    private void newLineIndent() throws IOException {
        this.writer.write(this.lineSeparator);
        for (int i = 0; i < this.indentLevel; ++i) {
            for (int j = 0; j < this.indentSize; ++j) {
                this.write(this.indentCharacter);
            }
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

