/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import by.fxg.basicfml.BasicFML;
import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.objects.ConfigCompoundEntry;
import by.fxg.basicfml.configv2.objects.InfoBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import scala.actors.threadpool.Arrays;

public final class ConfigBlockList
extends ConfigCompoundEntry {
    private IntermediaryArray array = null;
    private List<InfoBlock> blocks;

    public ConfigBlockList() {
        this.blocks = new ArrayList<InfoBlock>();
    }

    public ConfigBlockList(List<InfoBlock> blocks) {
        this.blocks = blocks;
    }

    public ConfigBlockList(InfoBlock ... blocks) {
        this.blocks = Arrays.asList((Object[])blocks);
    }

    @Override
    public IntermediaryWrapper serialize() {
        if (this.array == null) {
            this.array = new IntermediaryArray();
            for (InfoBlock stack : this.blocks) {
                this.array.append(stack.write());
            }
        }
        return this.array;
    }

    @Override
    public void deserialize(IntermediaryWrapper element) {
        if (element instanceof IntermediaryArray) {
            this.array = (IntermediaryArray)element;
            this.blocks.clear();
            for (IntermediaryWrapper wrapper : this.array) {
                IntermediaryPrimitive primitive;
                if (!(wrapper instanceof IntermediaryPrimitive) || !(primitive = (IntermediaryPrimitive)wrapper).isLiteral()) continue;
                InfoBlock stack = new InfoBlock(primitive.getString(), true);
                if (stack.isValid()) {
                    this.blocks.add(stack);
                    continue;
                }
                BasicFML.LOGGER.log(Level.WARNING, "Unable to parse block `{}` in config", primitive.getString());
            }
        }
    }

    public boolean contains(ItemStack stack, boolean deep) {
        return stack != null ? this.contains(stack, stack.func_77960_j(), deep) : false;
    }

    public boolean contains(ItemStack stack, int meta, boolean deep) {
        if (stack != null) {
            for (int idx = 0; idx < this.blocks.size(); ++idx) {
                if (!this.blocks.get(idx).equalsStack(stack, meta, deep)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Item item) {
        return this.contains(item, 0);
    }

    public boolean contains(Item item, int meta) {
        if (item != null) {
            for (int idx = 0; idx < this.blocks.size(); ++idx) {
                if (!this.blocks.get(idx).equalsItem(item, meta)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Block block) {
        return this.contains(block);
    }

    public boolean contains(Block block, int meta) {
        if (block != null) {
            for (int idx = 0; idx < this.blocks.size(); ++idx) {
                if (!this.blocks.get(idx).equalsBlock(block, meta)) continue;
                return true;
            }
        }
        return false;
    }

    public List<InfoBlock> getBlocks() {
        return this.blocks;
    }
}

