/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import by.fxg.basicfml.BasicFML;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveString;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.objects.ConfigCompoundEntry;

public final class ConfigTime
extends ConfigCompoundEntry {
    private final boolean wholeString;
    private IntermediaryWrapper primitive;
    private long millis;

    public ConfigTime() {
        this(0L, true);
    }

    public ConfigTime(long milliseconds) {
        this(milliseconds, true);
    }

    public ConfigTime(boolean wholeString) {
        this(0L, wholeString);
    }

    public ConfigTime(String string) {
        this(BasicFML.parseTime(string, 0L), true);
    }

    public ConfigTime(String string, boolean wholeString) {
        this(BasicFML.parseTime(string, 0L), wholeString);
    }

    public ConfigTime(long milliseconds, boolean wholeString) {
        this.millis = milliseconds;
        this.wholeString = wholeString;
    }

    @Override
    public IntermediaryWrapper serialize() {
        if (this.primitive == null) {
            if (this.wholeString) {
                StringBuilder builder = new StringBuilder();
                long time = this.millis;
                long timeToWrite = time / 604800000L;
                if (timeToWrite > 0L) {
                    time -= timeToWrite * 604800000L;
                    builder.append(timeToWrite).append("w ");
                }
                if ((timeToWrite = time / 86400000L) > 0L) {
                    time -= timeToWrite * 86400000L;
                    builder.append(timeToWrite).append("d ");
                }
                if ((timeToWrite = time / 3600000L) > 0L) {
                    time -= timeToWrite * 3600000L;
                    builder.append(timeToWrite).append("h ");
                }
                if ((timeToWrite = time / 60000L) > 0L) {
                    time -= timeToWrite * 60000L;
                    builder.append(timeToWrite).append("m ");
                }
                if ((timeToWrite = time / 1000L) > 0L) {
                    time -= timeToWrite * 1000L;
                    builder.append(timeToWrite).append("s ");
                }
                if (time > 0L) {
                    builder.append(time).append("ms ");
                }
                this.primitive = new IntermediaryPrimitiveString(builder.toString());
            } else {
                this.primitive = new IntermediaryPrimitiveString(this.millis + "ms");
            }
        }
        return this.primitive;
    }

    @Override
    public void deserialize(IntermediaryWrapper wrapper) {
        IntermediaryPrimitive primitive;
        if (wrapper instanceof IntermediaryPrimitive && (primitive = (IntermediaryPrimitive)wrapper).isLiteral()) {
            this.primitive = primitive;
            this.millis = BasicFML.parseTime(primitive.getString(), this.millis);
        }
    }

    public long getMilliseconds() {
        return this.millis;
    }

    public long getTicks() {
        return this.millis / 50L;
    }

    public ConfigTime setMilliseconds(long milliseconds) {
        this.millis = milliseconds;
        return this;
    }

    public ConfigTime setTicks(long ticks) {
        this.millis = ticks * 50L;
        return this;
    }
}

