/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.math.NumberUtils;

public final class InfoBlock {
    private boolean isValid = false;
    protected ItemStack stack;
    protected Block block;
    protected int meta;
    protected boolean anyMeta;

    public InfoBlock(ItemStack stack, boolean anyMeta) {
        this.stack = stack;
        this.anyMeta = anyMeta;
        this.isValid = this.invalidate();
    }

    public InfoBlock(ItemStack stack) {
        this(stack, false);
    }

    public InfoBlock(String string, boolean withFallback) {
        this.read(string, withFallback);
    }

    public InfoBlock() {
        this((ItemStack)null, false);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void ItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public int getMetadata() {
        return this.meta;
    }

    public void setMetadata(int metadata) {
        this.meta = metadata;
    }

    public boolean isAnyMeta() {
        return this.anyMeta;
    }

    public void setAnyMeta(boolean anyMeta) {
        this.anyMeta = anyMeta;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void read(String str, boolean withFallback) {
        ItemStack prevStack = this.stack;
        Block prevBlock = this.block;
        int prevMeta = this.meta;
        boolean prevAnyMeta = this.anyMeta;
        if (str.contains("<") && str.contains(">")) {
            String[] objects;
            String input = str.replaceAll("\\s+", "");
            int start = input.indexOf(60);
            int end = input.indexOf(62);
            if (end - start > 1 && (objects = input.substring(start + 1, end).split(":")) != null && objects.length > 1) {
                String namespace = objects[0];
                String object = objects[1];
                int meta = objects.length > 2 ? NumberUtils.toInt((String)objects[2], (int)0) : 0;
                Object item = Item.field_150901_e.func_82594_a(namespace + ":" + object);
                Object block = Block.field_149771_c.func_82594_a(namespace + ":" + object);
                this.stack = item instanceof Item ? new ItemStack((Item)item, 1, meta == -1 ? 0 : meta) : null;
                this.block = block instanceof Block ? (Block)block : null;
                this.meta = meta == -1 ? 0 : meta;
                this.anyMeta = meta == -1;
            }
        }
        this.isValid = this.invalidate();
        if (!this.isValid) {
            if (withFallback) {
                this.stack = prevStack;
                this.block = prevBlock;
                this.meta = prevMeta;
                this.anyMeta = prevAnyMeta;
                this.isValid = this.invalidate();
            } else {
                this.stack = null;
                this.block = null;
                this.meta = 0;
                this.anyMeta = false;
            }
        }
    }

    public String write() {
        if (this.stack != null && this.stack.func_77973_b() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append(Item.field_150901_e.func_148750_c((Object)this.stack.func_77973_b()));
            if (this.anyMeta) {
                builder.append(":*");
            } else if (this.stack.func_77960_j() != 0) {
                builder.append(":").append(this.stack.func_77960_j());
            }
            builder.append(">");
            if (this.stack.field_77994_a > 1) {
                builder.append(" * ").append(this.stack.field_77994_a);
            }
            return builder.toString();
        }
        return "<null>";
    }

    public boolean equalsInfo(InfoBlock other, boolean deep) {
        if (other == null || !this.isValid || !other.isValid) {
            return false;
        }
        if ((this.anyMeta || other.anyMeta || this.meta == other.meta) && this.stack.func_77973_b() == other.stack.func_77973_b() && this.block == other.block) {
            return deep ? ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.stack) : true;
        }
        return false;
    }

    public boolean equalsStack(ItemStack other, int meta, boolean deep) {
        if (!this.isValid || other == null) {
            return false;
        }
        if ((this.anyMeta || this.stack.func_77960_j() == meta) && this.stack.func_77973_b() == other.func_77973_b()) {
            return deep ? ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other) : true;
        }
        return false;
    }

    public boolean equalsItem(Item item) {
        return this.equalsItem(item, 0);
    }

    public boolean equalsItem(Item item, int meta) {
        if (!this.isValid || item == null) {
            return false;
        }
        return (this.anyMeta || this.meta == meta) && this.stack.func_77973_b() == item;
    }

    public boolean equalsBlock(Block block) {
        return this.equalsBlock(block, 0);
    }

    public boolean equalsBlock(Block block, int meta) {
        if (!this.isValid || block == null) {
            return false;
        }
        return this.block == block && (this.anyMeta || this.meta == meta);
    }

    private boolean invalidate() {
        return this.stack != null && this.stack.field_77994_a > 0 || this.block != null;
    }
}

