/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.util.INBTSerializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTank
implements IFluidTank,
INBTSerializable {
    protected int tankCapacity;
    @Nonnull
    protected FluidStack fluidContents;

    public FluidTank() {
        this(null, 0);
    }

    public FluidTank(int tankCapacity) {
        this(null, tankCapacity);
    }

    public FluidTank(@Nullable FluidStack fluidContents, int tankCapacity) {
        this.fluidContents = fluidContents != null ? fluidContents : new FluidStack(FluidRegistry.WATER, 0);
        this.tankCapacity = tankCapacity > 0 ? tankCapacity : 0;
    }

    public int getFluidID() {
        return this.fluidContents.getFluidID();
    }

    @Nonnull
    public Fluid getFluidObj() {
        return this.fluidContents.getFluid();
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluidContents;
    }

    public int getFluidAmount() {
        return this.fluidContents.amount;
    }

    public int getCapacity() {
        return this.tankCapacity;
    }

    @Nonnull
    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.fluidContents, this.fluidContents.amount);
    }

    public int fill(@Nonnull FluidStack fluidStack, boolean doFill) {
        if (!this.isFull()) {
            if (doFill) {
                if (this.isEmpty()) {
                    this.fluidContents = new FluidStack(fluidStack.getFluid(), Math.min(fluidStack.amount, this.tankCapacity), fluidStack.tag);
                    return this.fluidContents.amount;
                }
                int prevAmount = this.fluidContents.amount;
                this.fluidContents.amount = Math.min(this.fluidContents.amount + fluidStack.amount, this.tankCapacity);
                return this.fluidContents.amount - prevAmount;
            }
            return Math.min(this.fluidContents.amount + fluidStack.amount, this.tankCapacity);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.isEmpty()) {
            if (doDrain) {
                FluidStack drainedStack = this.fluidContents.copy();
                drainedStack.amount = Math.min(this.fluidContents.amount, maxDrain);
                this.fluidContents.amount -= drainedStack.amount;
                return drainedStack;
            }
            return new FluidStack(this.fluidContents.getFluid(), Math.min(this.fluidContents.amount, maxDrain), this.fluidContents.tag);
        }
        return null;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        tag.func_74768_a("capacity", this.tankCapacity);
        if (!this.isEmpty()) {
            tag.func_74778_a("fluid", this.fluidContents.getFluid().getName());
            tag.func_74768_a("amount", this.fluidContents.amount);
            if (this.fluidContents.tag != null) {
                tag.func_74782_a("fluidTag", (NBTBase)this.fluidContents.tag);
            }
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.tankCapacity = tag.func_74762_e("capacity");
        if (tag.func_74764_b("fluid")) {
            Fluid fluid = FluidRegistry.getFluid((String)tag.func_74779_i("fluid"));
            if (fluid != null) {
                this.fluidContents = new FluidStack(fluid, tag.func_74762_e("amount"));
                if (tag.func_74764_b("fluidTag")) {
                    this.fluidContents.tag = tag.func_74775_l("fluidTag");
                }
            } else {
                this.setEmpty();
            }
        } else {
            this.setEmpty();
        }
    }

    public void setFluid(@Nullable Fluid fluid) {
        this.fluidContents = fluid != null ? new FluidStack(fluid, this.fluidContents.amount) : new FluidStack(FluidRegistry.WATER, this.fluidContents.amount);
    }

    public void setFluid(@Nullable Fluid fluid, int amount) {
        this.fluidContents = fluid != null ? new FluidStack(fluid, amount) : new FluidStack(FluidRegistry.WATER, amount);
    }

    public void setFluidStack(@Nullable FluidStack fluidStack) {
        if (fluidStack != null) {
            this.fluidContents = fluidStack;
        } else {
            this.setEmpty();
        }
    }

    public void setEmpty() {
        this.fluidContents = new FluidStack(FluidRegistry.WATER, 0);
    }

    public void setCapacity(int capacity) {
        this.tankCapacity = Math.max(capacity, 0);
    }

    public void setCapacityWithFluidCap(int capacity) {
        this.tankCapacity = Math.max(capacity, 0);
        this.fluidContents.amount = Math.min(this.fluidContents.amount, capacity);
    }

    public void setFluidAmount(int amount) {
        this.fluidContents.amount = Math.min(amount, this.tankCapacity);
    }

    public boolean isFull() {
        return this.fluidContents.amount >= this.tankCapacity;
    }

    public boolean isEmpty() {
        return this.fluidContents.amount < 1;
    }

    public boolean isFluidValidForTank(@Nonnull FluidStack fluidStack) {
        return fluidStack != null && this.fluidContents.getFluidID() == fluidStack.getFluidID();
    }

    public boolean isFluidValidForTank(@Nonnull Fluid fluid) {
        return fluid != null && this.fluidContents.getFluidID() == fluid.getID();
    }

    public boolean canFill(@Nonnull Fluid fluid) {
        return this.isEmpty() || this.isFluidValidForTank(fluid) && !this.isFull();
    }

    public boolean canDrain(@Nonnull Fluid fluid) {
        return this.isFluidValidForTank(fluid) && !this.isEmpty();
    }
}

