/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.FluidTank;
import by.fxg.basicfml.util.IDirtyMarkable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankExt
extends FluidTank
implements IDirtyMarkable {
    protected boolean isDirty = false;

    public FluidTankExt() {
    }

    public FluidTankExt(int tankCapacity) {
        super(tankCapacity);
    }

    public FluidTankExt(@Nullable FluidStack fluidContents, int tankCapacity) {
        super(fluidContents, tankCapacity);
    }

    @Override
    public int getFluidID() {
        return !this.isEmpty() ? this.fluidContents.getFluidID() : -1;
    }

    @Override
    @Nullable
    public Fluid getFluidObj() {
        return !this.isEmpty() ? this.fluidContents.getFluid() : null;
    }

    @Override
    public int fill(@Nonnull FluidStack fluidStack, boolean doFill) {
        if (doFill) {
            int fillAmount = super.fill(fluidStack, doFill);
            this.setDirtyIf(fillAmount > 0);
            return fillAmount;
        }
        return super.fill(fluidStack, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (doDrain) {
            FluidStack drainAmount = super.drain(maxDrain, doDrain);
            this.setDirtyIf(drainAmount != null);
            return drainAmount;
        }
        return super.drain(maxDrain, doDrain);
    }

    @Override
    public void setFluid(@Nullable Fluid fluid) {
        super.setFluid(fluid);
        this.isDirty = true;
    }

    @Override
    public void setFluid(@Nullable Fluid fluid, int amount) {
        super.setFluid(fluid, amount);
        this.isDirty = true;
    }

    @Override
    public void setFluidStack(@Nullable FluidStack fluidStack) {
        super.setFluidStack(fluidStack);
        this.isDirty = true;
    }

    @Override
    public void setEmpty() {
        super.setEmpty();
        this.isDirty = true;
    }

    @Override
    public void setCapacity(int capacity) {
        this.setDirtyIf(this.tankCapacity != Math.max(capacity, 0));
        super.setCapacity(capacity);
    }

    @Override
    public void setCapacityWithFluidCap(int capacity) {
        this.setDirtyIf(this.tankCapacity != Math.max(capacity, 0));
        super.setCapacityWithFluidCap(capacity);
    }

    @Override
    public void setFluidAmount(int amount) {
        this.setDirtyIf(this.fluidContents.amount != Math.min(amount, this.tankCapacity));
        super.setFluidAmount(amount);
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean value) {
        this.isDirty = value;
    }
}

