/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.FluidTank;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankFunc
extends FluidTank {
    public static final BiFunction<FluidTankFunc, Fluid, Boolean> DEFAULT_CANFILL_FUNCTION = (tank, fluid) -> tank.isFluidValidForTank((Fluid)fluid) && !tank.isFull();
    public static final BiFunction<FluidTankFunc, Fluid, Boolean> DEFAULT_CANDRAIN_FUNCTION = (tank, fluid) -> tank.isFluidValidForTank((Fluid)fluid) && !tank.isEmpty();
    @Nonnull
    protected BiFunction<FluidTankFunc, Fluid, Boolean> canFillFunction = DEFAULT_CANFILL_FUNCTION;
    @Nonnull
    protected BiFunction<FluidTankFunc, Fluid, Boolean> canDrainFunction = DEFAULT_CANDRAIN_FUNCTION;

    public FluidTankFunc() {
    }

    public FluidTankFunc(int tankCapacity) {
        super(tankCapacity);
    }

    public FluidTankFunc(int tankCapacity, @Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canFillFunction, @Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canDrainFunction) {
        super(tankCapacity);
        this.canFillFunction = canFillFunction;
        this.canDrainFunction = canDrainFunction;
    }

    public FluidTankFunc(@Nullable FluidStack fluidContents, int tankCapacity) {
        super(fluidContents, tankCapacity);
    }

    public FluidTankFunc(@Nullable FluidStack fluidContents, int tankCapacity, @Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canFillFunction, @Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canDrainFunction) {
        super(fluidContents, tankCapacity);
        this.canFillFunction = canFillFunction != null ? canFillFunction : DEFAULT_CANFILL_FUNCTION;
        this.canDrainFunction = canDrainFunction != null ? canDrainFunction : DEFAULT_CANDRAIN_FUNCTION;
    }

    @Nonnull
    public FluidTankFunc setCanFillFunction(@Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canFillFunction) {
        this.canFillFunction = canFillFunction != null ? canFillFunction : DEFAULT_CANFILL_FUNCTION;
        return this;
    }

    @Nonnull
    public FluidTankFunc setCanDrainFunction(@Nullable BiFunction<FluidTankFunc, Fluid, Boolean> canDrainFunction) {
        this.canDrainFunction = canDrainFunction != null ? canDrainFunction : DEFAULT_CANDRAIN_FUNCTION;
        return this;
    }

    @Override
    public boolean canFill(@Nonnull Fluid fluid) {
        return this.canFillFunction.apply(this, fluid);
    }

    @Override
    public boolean canDrain(@Nonnull Fluid fluid) {
        return this.canDrainFunction.apply(this, fluid);
    }
}

