/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.IAdvancedInventory;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Inventory
implements IAdvancedInventory,
Iterable<ItemStack> {
    public final String name;
    public final ItemStack[] stacks;
    protected InventoryIterator iterator = null;

    protected Inventory(String name, ItemStack[] stacks) {
        this.name = name;
        this.stacks = stacks;
    }

    public Inventory(int size) {
        this(null, size);
    }

    public Inventory(String name, int size) {
        this.name = name;
        this.stacks = new ItemStack[size];
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot > -1 && slot < this.stacks.length ? this.stacks[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (slot < 0 || slot >= this.stacks.length) {
            return null;
        }
        ItemStack slotStack = this.stacks[slot];
        if (slotStack == null) {
            return null;
        }
        if (slotStack.field_77994_a <= size) {
            this.stacks[slot] = null;
            return slotStack;
        }
        ItemStack returnStack = slotStack.func_77979_a(size);
        if (slotStack.field_77994_a == 0) {
            this.stacks[slot] = null;
        }
        return returnStack;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            return null;
        }
        ItemStack stackInSlot = this.stacks[slot];
        if (stackInSlot != null) {
            this.stacks[slot] = null;
            return stackInSlot;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot > -1 && slot < this.stacks.length) {
            this.stacks[slot] = stack;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }

    public String func_145825_b() {
        return this.name;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
    }

    @Override
    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, 0, this.stacks.length - 1);
    }

    @Override
    public ItemStack addStack(ItemStack stack, int firstSlotIndex, int lastSlotIndex) {
        if (stack == null || lastSlotIndex < firstSlotIndex) {
            return null;
        }
        if (firstSlotIndex < 0) {
            firstSlotIndex = 0;
        }
        if (lastSlotIndex >= this.stacks.length) {
            lastSlotIndex = this.stacks.length - 1;
        }
        for (int i = firstSlotIndex; i <= lastSlotIndex; ++i) {
            ItemStack stackInSlot = this.stacks[i];
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack) || stackInSlot.field_77994_a >= stackInSlot.func_77976_d() || !ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            int decrStackSize = Math.min(stack.field_77994_a, stackInSlot.func_77976_d() - stackInSlot.field_77994_a);
            stackInSlot.field_77994_a += decrStackSize;
            stack.field_77994_a -= decrStackSize;
            if (stack.field_77994_a >= 1) continue;
            return null;
        }
        for (int slotIdx = firstSlotIndex; slotIdx <= lastSlotIndex; ++slotIdx) {
            if (this.stacks[slotIdx] != null) continue;
            this.stacks[slotIdx] = stack;
            return null;
        }
        return stack;
    }

    @Override
    public void collectStacks(Collection<ItemStack> collection, boolean removeFromInventory) {
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack stackInSlot = this.stacks[i];
            if (stackInSlot == null) continue;
            collection.add(stackInSlot);
            if (!removeFromInventory) continue;
            this.stacks[i] = null;
        }
    }

    @Override
    public void clear() {
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            this.stacks[slot] = null;
        }
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(name, (NBTBase)tagList);
    }

    public boolean readFromNBT(NBTTagCompound compound, String name) {
        if (!compound.func_74764_b(name)) {
            return false;
        }
        NBTTagList tagList = compound.func_150295_c(name, (int)compound.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot <= -1 || slot > this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tag));
        }
        return true;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        if (this.iterator == null) {
            this.iterator = new InventoryIterator(this);
        }
        this.iterator.resetIndex();
        return this.iterator;
    }

    public static Inventory createWrapper(ItemStack[] stacks) {
        return new Inventory(null, stacks);
    }

    public static Inventory createWrapper(String name, ItemStack[] stacks) {
        return new Inventory(name, stacks);
    }

    public static class InventoryIterator
    implements Iterator<ItemStack> {
        private final Inventory inventory;
        private int index = 0;

        public InventoryIterator(Inventory inventory) {
            this.inventory = inventory;
        }

        public void resetIndex() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.inventory.stacks.length > this.index;
        }

        @Override
        public ItemStack next() {
            return this.inventory.stacks[this.index++];
        }

        @Override
        public void remove() {
            this.inventory.stacks[this.index] = null;
        }
    }
}

