/*
 * Decompiled with CFR 0.152.
 */
package baubles.client.gui;

import baubles.Baubles;
import baubles.common.lib.EnumGearInventory;
import baubles.common.network.PacketActivateGear;
import baubles.common.player.ExtendedBaublesPlayer;
import baubles.common.player.SeparatedPlayerData;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import travellersgear.api.IActiveAbility;

public class GuiAbilityWheel
extends GuiScreen {
    private static final ResourceLocation WHEEL_TEXTURE = new ResourceLocation("baubles", "textures/gui/radialmenu.png");
    private List<WheelEntry> entries = new ArrayList<WheelEntry>();
    private int wheelAlpha;
    private float wheelRotation = 0.0f;
    private int halfSize;

    public GuiAbilityWheel() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        SeparatedPlayerData data = ExtendedBaublesPlayer.get((EntityPlayer)player).getData();
        this.addEntries(EnumGearInventory.BAUBLES, (IInventory)data.inventoryBaubles, 0, 4);
        this.addEntries(EnumGearInventory.TGEAR, (IInventory)data.inventoryTGear, 0, 4);
        this.addEntries(EnumGearInventory.PLAYER_INVENTORY, (IInventory)player.field_71071_by, 0, 9);
        this.addEntries(EnumGearInventory.PLAYER_INVENTORY, (IInventory)player.field_71071_by, 36, 4);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.halfSize = Math.min(this.field_146294_l, this.field_146295_m) / 4;
    }

    public void func_73876_c() {
        this.wheelRotation += 0.4f;
        if (this.wheelAlpha < 6) {
            ++this.wheelAlpha;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.field_78398_a;
        this.field_146297_k.field_71446_o.func_110577_a(WHEEL_TEXTURE);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_146294_l / 2), (float)(this.field_146295_m / 2), (float)0.0f);
        GL11.glRotatef((float)this.wheelRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        tess.func_78382_b();
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.8f * ((float)this.wheelAlpha / 6.0f));
        tess.func_78374_a((double)(-this.halfSize), (double)(-this.halfSize), 0.0, 0.0, 0.0);
        tess.func_78374_a((double)(-this.halfSize), (double)this.halfSize, 0.0, 0.0, 1.0);
        tess.func_78374_a((double)this.halfSize, (double)this.halfSize, 0.0, 1.0, 1.0);
        tess.func_78374_a((double)this.halfSize, (double)(-this.halfSize), 0.0, 1.0, 0.0);
        tess.func_78381_a();
        GL11.glRotatef((float)(-this.wheelRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        int offsetMouseX = mouseX - this.field_146294_l / 2;
        int offsetMouseY = mouseY - this.field_146295_m / 2;
        float imageOffset = (float)this.halfSize * 0.785f;
        float radialSlice = 360.0f / (float)this.entries.size();
        float rotation = -90.0f;
        boolean tooltipRendered = false;
        RenderHelper.func_74520_c();
        for (WheelEntry entry : this.entries) {
            float sliceX = MathHelper.func_76134_b((float)((rotation += radialSlice) / 180.0f * (float)Math.PI)) * imageOffset;
            float sliceY = MathHelper.func_76126_a((float)(rotation / 180.0f * (float)Math.PI)) * imageOffset;
            GL11.glPushMatrix();
            if (!tooltipRendered && sliceX - 8.0f < (float)offsetMouseX && (float)offsetMouseX < sliceX + 8.0f && sliceY - 8.0f < (float)offsetMouseY && (float)offsetMouseY < sliceY + 8.0f) {
                this.drawHoveringText(entry.stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x), -(this.field_146294_l / 2), -(this.field_146295_m / 2));
                GL11.glTranslatef((float)(sliceX - 10.0f), (float)(sliceY - 10.0f), (float)10.0f);
                GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                field_146296_j.renderItemIntoGUI(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), entry.stack, 0, 0, true);
                tooltipRendered = true;
            } else {
                GL11.glTranslatef((float)(sliceX - 8.0f), (float)(sliceY - 8.0f), (float)10.0f);
                field_146296_j.renderItemIntoGUI(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), entry.stack, 0, 0, true);
            }
            GL11.glPopMatrix();
        }
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            int offsetMouseX = mouseX - this.field_146294_l / 2;
            int offsetMouseY = mouseY - this.field_146295_m / 2;
            float imageOffset = (float)this.halfSize * 0.785f;
            float radialSlice = 360.0f / (float)this.entries.size();
            float rotation = -90.0f;
            for (WheelEntry entry : this.entries) {
                float sliceX = MathHelper.func_76134_b((float)((rotation += radialSlice) / 180.0f * (float)Math.PI)) * imageOffset;
                float sliceY = MathHelper.func_76126_a((float)(rotation / 180.0f * (float)Math.PI)) * imageOffset;
                if (!(sliceX - 8.0f < (float)offsetMouseX) || !((float)offsetMouseX < sliceX + 8.0f) || !(sliceY - 8.0f < (float)offsetMouseY) || !((float)offsetMouseY < sliceY + 8.0f)) continue;
                this.field_146297_k.field_71439_g.func_85030_a("random.orb", 0.1f, 1.15f);
                Baubles.NETWORK.sendToServer((IMessage)new PacketActivateGear(entry.inventory, entry.slot));
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.field_146297_k.func_71381_h();
                return;
            }
        } else if (mouseButton == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73869_a(char character, int key) {
        switch (key) {
            case 1: 
            case 57: {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.field_146297_k.func_71381_h();
            }
        }
    }

    protected void drawHoveringText(List text, int x, int y) {
        if (!text.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int w = 0;
            Iterator iterator = text.iterator();
            while (iterator.hasNext()) {
                int strWidth = this.field_146297_k.field_71466_p.func_78256_a((String)iterator.next());
                if (strWidth <= w) continue;
                w = strWidth;
            }
            int rx = x + 6;
            int rh = 8;
            y += 6;
            if (text.size() > 1) {
                rh += 2 + (text.size() - 1) * 10;
            }
            int j1 = -267386864;
            this.func_73733_a(rx - 3, y - 4, rx + w + 3, y - 3, j1, j1);
            this.func_73733_a(rx - 3, y + rh + 3, rx + w + 3, y + rh + 4, j1, j1);
            this.func_73733_a(rx - 3, y - 3, rx + w + 3, y + rh + 3, j1, j1);
            this.func_73733_a(rx - 4, y - 3, rx - 3, y + rh + 3, j1, j1);
            this.func_73733_a(rx + w + 3, y - 3, rx + w + 4, y + rh + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(rx - 3, y - 3 + 1, rx - 3 + 1, y + rh + 3 - 1, k1, l1);
            this.func_73733_a(rx + w + 2, y - 3 + 1, rx + w + 3, y + rh + 3 - 1, k1, l1);
            this.func_73733_a(rx - 3, y - 3, rx + w + 3, y - 3 + 1, k1, k1);
            this.func_73733_a(rx - 3, y + rh + 2, rx + w + 3, y + rh + 3, l1, l1);
            for (int i$ = 0; i$ < text.size(); ++i$) {
                this.field_146297_k.field_71466_p.func_78261_a((String)text.get(i$), rx, y, -1);
                y += i$ == 0 ? 12 : 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    private void addEntries(EnumGearInventory gearInventory, IInventory inventory, int startSlot, int slots) {
        for (int i = startSlot; i != startSlot + slots; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IActiveAbility)) continue;
            this.entries.add(new WheelEntry(gearInventory, startSlot + i, stack));
        }
    }

    private class WheelEntry {
        public final ItemStack stack;
        public final int slot;
        public final EnumGearInventory inventory;

        public WheelEntry(EnumGearInventory inventory, int slot, ItemStack stack) {
            this.stack = stack;
            this.slot = slot;
            this.inventory = inventory;
        }
    }
}

