/*
 * Decompiled with CFR 0.152.
 */
package baubles.common;

import by.fxg.basicfml.configuration.BasicGsonConfiguration;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BaublesConfiguration
extends BasicGsonConfiguration {
    public static boolean USE_SPLIT_WORLDS = false;
    public static boolean PRESERVE_OLD_INVENTORIES = true;
    public static int BACKING_INVENTORY_DIMENSION = 0;
    public static final List<Integer> WORLDS_INVENTORIES = new ArrayList<Integer>();

    public BaublesConfiguration(File gsonConfigFile) {
        super(gsonConfigFile);
        this.registerAsReloadable("baubles");
        WORLDS_INVENTORIES.add(0);
    }

    protected void serialize(JsonObject object) {
        JsonObject baubles = new JsonObject();
        baubles.addProperty("useSplitWorlds", Boolean.valueOf(USE_SPLIT_WORLDS));
        baubles.addProperty("preserveOldInventories", Boolean.valueOf(PRESERVE_OLD_INVENTORIES));
        baubles.addProperty("backingInventoryDimension", (Number)BACKING_INVENTORY_DIMENSION);
        JsonArray worldInventories = new JsonArray();
        WORLDS_INVENTORIES.forEach(dim -> worldInventories.add((JsonElement)new JsonPrimitive((Number)dim)));
        baubles.add("worldsInventories", (JsonElement)worldInventories);
        object.add("baubles", (JsonElement)baubles);
    }

    protected void deserialize(JsonObject object) {
        if (object != null && object.has("baubles")) {
            JsonObject baubles = object.getAsJsonObject("baubles");
            USE_SPLIT_WORLDS = baubles.has("useSplitWorlds") ? baubles.get("useSplitWorlds").getAsBoolean() : USE_SPLIT_WORLDS;
            PRESERVE_OLD_INVENTORIES = baubles.has("preserveOldInventories") ? baubles.get("preserveOldInventories").getAsBoolean() : PRESERVE_OLD_INVENTORIES;
            int n = BACKING_INVENTORY_DIMENSION = baubles.has("backingInventoryDimension") ? baubles.get("backingInventoryDimension").getAsInt() : BACKING_INVENTORY_DIMENSION;
            if (baubles.has("worldsInventories")) {
                WORLDS_INVENTORIES.clear();
                JsonArray worldsInventories = baubles.getAsJsonArray("worldsInventories");
                for (int i = 0; i != worldsInventories.size(); ++i) {
                    JsonElement element = worldsInventories.get(i);
                    if (!(element instanceof JsonPrimitive) || !((JsonPrimitive)element).isNumber()) continue;
                    WORLDS_INVENTORIES.add(element.getAsInt());
                }
            }
        }
    }
}

