/*
 * Decompiled with CFR 0.152.
 */
package baubles.common;

import baubles.api.IBauble;
import baubles.common.player.ExtendedBaublesPlayer;
import baubles.common.player.SeparatedPlayerData;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import travellersgear.api.IEventGear;
import travellersgear.api.ITravellersGear;

public class CommonEventHandler {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedBaublesPlayer.get((EntityPlayer)event.entity) == null) {
            ((EntityPlayer)event.entity).registerExtendedProperties("Baubles", (IExtendedEntityProperties)new ExtendedBaublesPlayer((EntityPlayer)event.entity));
        }
    }

    @SubscribeEvent
    public void onEntityClone(PlayerEvent.Clone event) {
        ExtendedBaublesPlayer.get(event.entityPlayer).cloneFrom(ExtendedBaublesPlayer.get(event.original));
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            SeparatedPlayerData spd = ExtendedBaublesPlayer.get(player).getData();
            spd.inventoryBaubles.forEach(stack -> {
                if (stack != null && stack.func_77973_b() instanceof IBauble) {
                    ((IBauble)stack.func_77973_b()).onWornTick((ItemStack)stack, (EntityLivingBase)player);
                }
            });
            spd.inventoryTGear.forEach(stack -> {
                if (stack != null && stack.func_77973_b() instanceof ITravellersGear) {
                    ((ITravellersGear)stack.func_77973_b()).onTravelGearTick(player, (ItemStack)stack);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerTargeted(LivingSetAttackTargetEvent event) {
        if (event.target instanceof EntityPlayer) {
            Iterator iterator = ExtendedBaublesPlayer.get((EntityPlayer)((EntityPlayer)event.target)).getData().inventoryTGear.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack == null || !(stack.func_77973_b() instanceof IEventGear)) continue;
                ((IEventGear)stack.func_77973_b()).onUserTargeted(event, stack);
            }
        }
    }
}

