/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.container;

import by.fxg.basicfml.inventory.Inventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class BasicInventory
extends Inventory {
    public EntityPlayer player;

    public BasicInventory(EntityPlayer player, int size) {
        super(size);
        this.player = player;
    }

    public abstract void syncInventory(EntityPlayer var1);

    protected abstract void onItemUnequipped(ItemStack var1);

    protected abstract void onItemEquipped(ItemStack var1);

    public BasicInventory setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.stacks[slot] != null) {
            if (this.stacks[slot].field_77994_a <= size) {
                ItemStack stack = this.stacks[slot];
                this.onItemUnequipped(stack);
                this.stacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.stacks[slot].func_77979_a(size);
            this.onItemUnequipped(stack);
            if (this.stacks[slot].field_77994_a == 0) {
                this.stacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot > -1 && slot < this.stacks.length) {
            this.stacks[slot] = stack;
            this.onItemEquipped(stack);
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70296_d() {
        this.syncInventory(this.player);
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(name, (NBTBase)tagList);
    }

    public boolean readFromNBT(NBTTagCompound compound, String name) {
        if (!compound.func_74764_b(name)) {
            return false;
        }
        NBTTagList tagList = compound.func_150295_c(name, (int)compound.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot <= -1 || slot > this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tag));
        }
        return true;
    }
}

