/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.network;

import baubles.common.container.BasicInventory;
import baubles.common.player.ExtendedBaublesPlayer;
import baubles.common.player.SeparatedPlayerData;
import by.fxg.basicfml.network.SidedMessageHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketSyncInventory
implements IMessage {
    public String username;
    public boolean isBaubles;
    public ItemStack[] stacks;

    public PacketSyncInventory() {
    }

    public PacketSyncInventory(String username, boolean isBaubles, ItemStack[] stacks) {
        this.username = username;
        this.isBaubles = isBaubles;
        this.stacks = stacks;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
        buf.writeBoolean(this.isBaubles);
        buf.writeInt(this.stacks.length);
        for (int i = 0; i != this.stacks.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stacks[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isBaubles = buf.readBoolean();
        this.stacks = new ItemStack[buf.readInt()];
        for (int i = 0; i != this.stacks.length; ++i) {
            this.stacks[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public static class Handler
    implements SidedMessageHandler<PacketSyncInventory, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onClientMessage(PacketSyncInventory message, MessageContext ctx) {
            BasicInventory inventory = null;
            if (message.username.equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_111285_a())) {
                SeparatedPlayerData spd = ExtendedBaublesPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getData();
                inventory = message.isBaubles ? spd.inventoryBaubles : spd.inventoryTGear;
            } else {
                SeparatedPlayerData spd;
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_72924_a(message.username);
                SeparatedPlayerData separatedPlayerData = spd = player != null ? ExtendedBaublesPlayer.get(player).getData() : null;
                if (spd != null) {
                    BasicInventory basicInventory = inventory = message.isBaubles ? spd.inventoryBaubles : spd.inventoryTGear;
                }
            }
            if (inventory != null) {
                int slots = Math.min(message.stacks.length, inventory.func_70302_i_());
                for (int i = 0; i != slots; ++i) {
                    inventory.func_70299_a(i, message.stacks[i]);
                }
            }
            return null;
        }
    }
}

