/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.player;

import baubles.common.BaublesConfiguration;
import baubles.common.player.SeparatedPlayerData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedBaublesPlayer
implements IExtendedEntityProperties {
    private static final Function<ExtendedBaublesPlayer, SeparatedPlayerData> splitWorldSupplier = ieep -> {
        int dimensionID = BaublesConfiguration.WORLDS_INVENTORIES.contains(ieep.player.field_71093_bK) ? ieep.player.field_71093_bK : BaublesConfiguration.BACKING_INVENTORY_DIMENSION;
        SeparatedPlayerData data = ieep.dimensionData.get(dimensionID);
        if (data == null) {
            data = new SeparatedPlayerData(ieep.player);
            ieep.dimensionData.put(dimensionID, data);
        }
        return data;
    };
    private static final Function<ExtendedBaublesPlayer, SeparatedPlayerData> defaultSupplier = ieep -> {
        SeparatedPlayerData data = ieep.dimensionData.get(0);
        if (data == null) {
            data = new SeparatedPlayerData(ieep.player);
            ieep.dimensionData.put(0, data);
        }
        return data;
    };
    private final EntityPlayer player;
    private final Function<ExtendedBaublesPlayer, SeparatedPlayerData> dataSupplier;
    private Map<Integer, SeparatedPlayerData> dimensionData = new ConcurrentHashMap<Integer, SeparatedPlayerData>();

    public ExtendedBaublesPlayer(EntityPlayer player) {
        this.player = player;
        this.dataSupplier = BaublesConfiguration.USE_SPLIT_WORLDS ? splitWorldSupplier : defaultSupplier;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList dimensionData = new NBTTagList();
        this.dimensionData.entrySet().forEach(entry -> {
            if (entry != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("dimension", ((Integer)entry.getKey()).intValue());
                ((SeparatedPlayerData)entry.getValue()).saveNBTData(tag, "data");
                dimensionData.func_74742_a((NBTBase)tag);
            }
        });
        compound.func_74782_a("separatedData", (NBTBase)dimensionData);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList dimensionData = compound.func_150295_c("separatedData", (int)compound.func_74732_a());
        for (int i = 0; i != dimensionData.func_74745_c(); ++i) {
            NBTTagCompound tag = dimensionData.func_150305_b(i);
            int dimension = tag.func_74762_e("dimension");
            SeparatedPlayerData data = this.dimensionData.get(dimension);
            if (data == null) {
                if (!BaublesConfiguration.PRESERVE_OLD_INVENTORIES && !BaublesConfiguration.WORLDS_INVENTORIES.contains(dimension)) continue;
                data = new SeparatedPlayerData(this.player);
                this.dimensionData.put(dimension, data);
            }
            data.loadNBTData(tag, "data");
        }
    }

    public SeparatedPlayerData getData() {
        return this.dataSupplier.apply(this);
    }

    public SeparatedPlayerData getData(int dimension, boolean enableBacking) {
        boolean inventoryAllowed = BaublesConfiguration.WORLDS_INVENTORIES.contains(dimension);
        if (!inventoryAllowed && !enableBacking) {
            return null;
        }
        int dimensionID = inventoryAllowed ? dimension : BaublesConfiguration.BACKING_INVENTORY_DIMENSION;
        SeparatedPlayerData data = this.dimensionData.get(dimensionID);
        if (data == null) {
            data = new SeparatedPlayerData(this.player);
            this.dimensionData.put(dimensionID, data);
        }
        return data;
    }

    public void cloneFrom(ExtendedBaublesPlayer player) {
        this.dimensionData = player.dimensionData;
        this.dimensionData.values().forEach(data -> data.onClone(this.player));
    }

    public void init(Entity entity, World world) {
    }

    public static ExtendedBaublesPlayer get(EntityPlayer player) {
        return (ExtendedBaublesPlayer)player.getExtendedProperties("Baubles");
    }
}

