/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.bbw.common.item;

import by.fxg.bbw.common.util.BlockCoord;
import by.fxg.bbw.common.util.EnumFluidLock;
import by.fxg.bbw.common.util.EnumLock;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.THashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import ru.justagod.cutter.invoke.Invoke;

public class ItemBuilderWand
extends Item {
    protected int blocksLimit = 1;
    protected EnumLock[] allowedLockModes = EnumLock.values();
    protected EnumFluidLock[] allowedFluidLockModes = EnumFluidLock.values();
    private static int tmpHashCode;

    public ItemBuilderWand(String name) {
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77664_n();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List lines, boolean extraInfo) {
        lines.add(StatCollector.func_74838_a((String)this.getLock((ItemStack)itemstack).name));
        lines.add(StatCollector.func_74838_a((String)this.getFluidLock((ItemStack)itemstack).name));
        lines.add(StatCollector.func_74837_a((String)"bbw.hover.maxblocks", (Object[])new Object[]{this.getWandBlocksLimit(itemstack)}));
    }

    public boolean damageWandShouldContinue(EntityPlayer player, ItemStack wandStack) {
        return true;
    }

    public ItemBuilderWand setBlocksLimit(int limit) {
        this.blocksLimit = limit;
        return this;
    }

    public int getWandBlocksLimit(ItemStack wandStack) {
        return Math.min(wandStack.func_77958_k() - wandStack.func_77960_j(), this.blocksLimit);
    }

    public int getBlocksLimit(EntityPlayer player, ItemStack wandStack, ItemStack blockStack) {
        return !player.field_71075_bZ.field_75098_d ? Math.min(this.getWandBlocksLimit(wandStack), this.getItemsAmount(player, blockStack)) : this.blocksLimit;
    }

    public ItemBuilderWand setAllowedLock(EnumLock ... values) {
        EnumLock[] enumLockArray;
        if (values.length > 0) {
            enumLockArray = values;
        } else {
            EnumLock[] enumLockArray2 = new EnumLock[1];
            enumLockArray = enumLockArray2;
            enumLockArray2[0] = EnumLock.HORIZONTAL;
        }
        this.allowedLockModes = enumLockArray;
        return this;
    }

    public ItemBuilderWand setAllowedFluidLock(EnumFluidLock ... values) {
        EnumFluidLock[] enumFluidLockArray;
        if (values.length > 0) {
            enumFluidLockArray = values;
        } else {
            EnumFluidLock[] enumFluidLockArray2 = new EnumFluidLock[1];
            enumFluidLockArray = enumFluidLockArray2;
            enumFluidLockArray2[0] = EnumFluidLock.STOPAT;
        }
        this.allowedFluidLockModes = enumFluidLockArray;
        return this;
    }

    public EnumLock getLock(ItemStack stack) {
        if (stack != null) {
            NBTTagCompound tag = this.getOrCreateTagCompound(stack);
            return EnumLock.fromOrdinal(tag.func_74762_e("bbwLock"));
        }
        return EnumLock.HORIZONTAL;
    }

    public ItemBuilderWand setLock(ItemStack stack, EnumLock lock) {
        if (stack != null) {
            NBTTagCompound tag = this.getOrCreateTagCompound(stack);
            tag.func_74768_a("bbwLock", lock.ordinal());
        }
        return this;
    }

    public EnumFluidLock getFluidLock(ItemStack stack) {
        if (stack != null) {
            NBTTagCompound tag = this.getOrCreateTagCompound(stack);
            return EnumFluidLock.fromOrdinal(tag.func_74762_e("bbwFluidLock"));
        }
        return EnumFluidLock.STOPAT;
    }

    public ItemBuilderWand setFluidLock(ItemStack stack, EnumFluidLock lock) {
        if (stack != null) {
            NBTTagCompound tag = this.getOrCreateTagCompound(stack);
            tag.func_74768_a("bbwFluidLock", lock.ordinal());
        }
        return this;
    }

    public boolean func_77648_a(ItemStack wandStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return Invoke.serverValue(() -> false);
        }
        return true;
    }

    protected NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        if (stack != null) {
            if (!stack.func_77942_o()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("bbwLock", this.allowedLockModes[0].ordinal());
                tag.func_74768_a("bbwFluidLock", this.allowedFluidLockModes[0].ordinal());
                stack.func_77982_d(tag);
            }
            return stack.func_77978_p();
        }
        return null;
    }

    public Set<BlockCoord> getBlockPositionList(World world, BlockCoord lookingAt, ForgeDirection placeDir, int blockLimit, EnumLock lockMode, EnumFluidLock fluidLockMode, ItemStack blockStack) {
        BlockCoord startingPoint = lookingAt.move(placeDir);
        Block originBlock = world.func_147439_a(lookingAt.x, lookingAt.y, lookingAt.z);
        int originMeta = world.func_72805_g(lookingAt.x, lookingAt.y, lookingAt.z);
        LinkedList<BlockCoord> loopingCandidates = new LinkedList<BlockCoord>();
        TIntArrayList parsedCandidates = new TIntArrayList(blockLimit);
        THashSet candidatesToPlace = new THashSet();
        if ((lockMode != EnumLock.HORIZONTAL && lockMode != EnumLock.VERTICAL || placeDir != ForgeDirection.UP && placeDir != ForgeDirection.DOWN) && (lockMode != EnumLock.NORTHSOUTH || placeDir != ForgeDirection.NORTH && placeDir != ForgeDirection.SOUTH) && (lockMode != EnumLock.EASTWEST || placeDir != ForgeDirection.EAST && placeDir != ForgeDirection.WEST)) {
            loopingCandidates.add(startingPoint);
        }
        while (loopingCandidates.size() > 0 && candidatesToPlace.size() < blockLimit) {
            AxisAlignedBB blockAABB;
            int supportMeta;
            BlockCoord currentPos = (BlockCoord)loopingCandidates.removeFirst();
            BlockCoord supportCoord = currentPos.move(placeDir.getOpposite());
            Block supportBlock = world.func_147439_a(supportCoord.x, supportCoord.y, supportCoord.z);
            if (!this.isValidCandidate(world, currentPos, originBlock, originMeta, supportBlock, supportMeta = world.func_72805_g(supportCoord.x, supportCoord.y, supportCoord.z), blockAABB = originBlock.func_149668_a(world, currentPos.x, currentPos.y, currentPos.z), blockStack, fluidLockMode)) continue;
            candidatesToPlace.add(currentPos);
            switch (placeDir) {
                case DOWN: 
                case UP: {
                    if (lockMode.isNorthSouth()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.NORTH));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.SOUTH));
                    }
                    if (lockMode.isEastWest()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.EAST));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.WEST));
                    }
                    if (!lockMode.isNorthSouth() || !lockMode.isEastWest()) break;
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.NORTH).move(ForgeDirection.EAST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.NORTH).move(ForgeDirection.WEST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.SOUTH).move(ForgeDirection.EAST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.SOUTH).move(ForgeDirection.WEST));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (lockMode.isVertical()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN));
                    }
                    if (lockMode.isEastWest()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.EAST));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.WEST));
                    }
                    if (!lockMode.isVertical() || !lockMode.isEastWest()) break;
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP).move(ForgeDirection.EAST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP).move(ForgeDirection.WEST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN).move(ForgeDirection.EAST));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN).move(ForgeDirection.WEST));
                    break;
                }
                case WEST: 
                case EAST: {
                    if (lockMode.isVertical()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN));
                    }
                    if (lockMode.isNorthSouth()) {
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.NORTH));
                        this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.SOUTH));
                    }
                    if (!lockMode.isVertical() || !lockMode.isNorthSouth()) break;
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP).move(ForgeDirection.NORTH));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.UP).move(ForgeDirection.SOUTH));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN).move(ForgeDirection.NORTH));
                    this.addIfNotContains((TIntList)parsedCandidates, loopingCandidates, currentPos.move(ForgeDirection.DOWN).move(ForgeDirection.SOUTH));
                }
            }
        }
        return candidatesToPlace;
    }

    private <T> void addIfNotContains(TIntList memoryList, List<T> listForAdding, T object) {
        tmpHashCode = object.hashCode();
        if (!memoryList.contains(tmpHashCode)) {
            memoryList.add(tmpHashCode);
            listForAdding.add(object);
        }
    }

    protected boolean isValidCandidate(World world, BlockCoord currentPos, Block originBlock, int originMeta, Block supportBlock, int supportMeta, AxisAlignedBB blockAABB, ItemStack blockStack, EnumFluidLock fluidLockMode) {
        if (!world.func_147437_c(currentPos.x, currentPos.y, currentPos.z)) {
            Block currentBlock = world.func_147439_a(currentPos.x, currentPos.y, currentPos.z);
            if (currentBlock != null && (currentBlock instanceof IFluidBlock || currentBlock instanceof BlockLiquid) && fluidLockMode == EnumFluidLock.STOPAT) {
                return false;
            }
            if (!originBlock.func_149705_a(world, currentPos.x, currentPos.y, currentPos.z, originMeta, blockStack)) {
                return false;
            }
            if (currentBlock.equals(originBlock)) {
                return false;
            }
        }
        if (!originBlock.equals(supportBlock) || originMeta != supportMeta || !originBlock.func_149742_c(world, currentPos.x, currentPos.y, currentPos.z)) {
            return false;
        }
        if (!originBlock.func_149718_j(world, currentPos.x, currentPos.y, currentPos.z)) {
            return false;
        }
        return blockAABB == null || world.func_72872_a(EntityLivingBase.class, blockAABB).size() < 1;
    }

    public int getItemsAmount(EntityPlayer player, ItemStack comparableStack) {
        int amountAvailable = 0;
        ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i != mainInventory.length; ++i) {
            if (mainInventory[i] == null || !comparableStack.func_77969_a(mainInventory[i])) continue;
            amountAvailable += mainInventory[i].field_77994_a;
        }
        return amountAvailable;
    }

    public ItemStack getValidItemStackForBlock(World world, Block block, int metadata) {
        if (block != null) {
            Item blockItem = Item.func_150898_a((Block)block);
            if (blockItem == block.func_149650_a(metadata, world.field_73012_v, 0)) {
                return new ItemStack(blockItem, 1, blockItem.func_77614_k() ? block.func_149692_a(metadata) : 0);
            }
            return new ItemStack(blockItem, 1, blockItem.func_77614_k() ? metadata : 0);
        }
        return null;
    }
}

