/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.bbw.common.util;

import net.minecraftforge.common.util.ForgeDirection;

public class BlockCoord {
    public static int UP = 1;
    public static int DOWN = -1;
    public static int EAST = 1;
    public static int WEST = -1;
    public static int SOUTH = 1;
    public static int NORTH = -1;
    public int x;
    public int y;
    public int z;

    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockCoord move(ForgeDirection direction) {
        int newX = this.x;
        int newY = this.y;
        int newZ = this.z;
        switch (direction) {
            case UP: {
                ++newY;
                break;
            }
            case DOWN: {
                --newY;
                break;
            }
            case NORTH: {
                --newZ;
                break;
            }
            case SOUTH: {
                ++newZ;
                break;
            }
            case EAST: {
                ++newX;
                break;
            }
            case WEST: {
                --newX;
            }
        }
        return new BlockCoord(newX, newY, newZ);
    }

    public BlockCoord move(int dx, int dy, int dz) {
        int newX = this.x;
        int newY = this.y;
        int newZ = this.z;
        return new BlockCoord(newX += dx, newY += dy, newZ += dz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BlockCoord that = (BlockCoord)o;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public int hashCode() {
        int hashX = this.x << 22;
        int hashY = this.y << 22 >> 10;
        int hashZ = this.z << 22 >> 20;
        return hashX + hashY + hashZ;
    }

    public String toString() {
        return String.format("(%d,%d,%d)", this.x, this.y, this.z);
    }
}

