/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.blockrenderer;

import com.google.common.io.Files;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Mod(acceptableRemoteVersions="*", acceptableSaveVersions="*", dependencies="after:*", version="0.3", name="BlockRenderer", modid="blockrenderer")
public class BlockRenderer {
    private KeyBinding bind;
    private boolean down;

    private static BufferedImage createFlipped(BufferedImage image) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -image.getHeight()));
        return BlockRenderer.createTransformed(image, at);
    }

    private static BufferedImage createTransformed(BufferedImage image, AffineTransform at) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.transform(at);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        this.bind = new KeyBinding("key.render", 41, "key.categories.blockrenderer");
        ClientRegistry.registerKeyBinding((KeyBinding)this.bind);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            int code = this.bind.func_151463_i();
            if (code > 256) {
                return;
            }
            if (Keyboard.isKeyDown((int)code)) {
                if (!this.down) {
                    this.down = true;
                    Minecraft mc = Minecraft.func_71410_x();
                    GuiScreen currentScreen = mc.field_71462_r;
                    if (currentScreen instanceof GuiContainer) {
                        int y;
                        int w = currentScreen.field_146294_l;
                        int h = currentScreen.field_146295_m;
                        int x = Mouse.getX() * w / mc.field_71443_c;
                        Slot s = ((GuiContainer)currentScreen).func_146975_c(x, y = h - Mouse.getY() * h / mc.field_71440_d - 1);
                        if (s != null) {
                            ItemStack is = s.func_75211_c();
                            if (is != null) {
                                ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                                int size = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 16 * res.func_78325_e() : Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), 512);
                                int damage = Math.max(is.func_77960_j(), 0);
                                String outName = Item.field_150901_e.func_148750_c((Object)is.func_77973_b()).replace(":", "_").replace("minecraft_", "").replace(".", "") + "_" + damage;
                                String filename = "renders/" + outName.toUpperCase() + ".png";
                                GL11.glPushMatrix();
                                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                                GL11.glClear((int)16640);
                                mc.field_71460_t.func_78478_c();
                                RenderHelper.func_74520_c();
                                float scale = (float)size / (16.0f * (float)res.func_78325_e());
                                System.out.println(scale);
                                GL11.glTranslatef((float)0.0f, (float)((float)res.func_78328_b() - scale * 16.0f), (float)0.0f);
                                GL11.glScalef((float)scale, (float)scale, (float)scale);
                                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-50.0f);
                                if (is.func_77973_b().func_77623_v()) {
                                    GL11.glDisable((int)2929);
                                } else {
                                    GL11.glEnable((int)2929);
                                }
                                RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, is, 0, 0);
                                GL11.glPopMatrix();
                                try {
                                    BufferedImage img = BlockRenderer.createFlipped(this.readPixels(size, size));
                                    File f = new File(filename);
                                    Files.createParentDirs((File)f);
                                    f.createNewFile();
                                    ImageIO.write((RenderedImage)img, "PNG", f);
                                    mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Rendered to " + filename));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Rendering failed, see game output for details"));
                                }
                            } else {
                                mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("That slot has no item"));
                            }
                        } else {
                            mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("There's no slot there"));
                        }
                    } else {
                        mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Can't find an item to render"));
                    }
                }
            } else {
                this.down = false;
            }
        }
    }

    public BufferedImage readPixels(int width, int height) {
        GL11.glReadBuffer((int)1029);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buf);
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        buf.asIntBuffer().get(pixels);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        return img;
    }
}

