/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class AlchemyPotionHelper {
    private int potionID;
    private int tickDuration;
    private int concentration;
    private int durationFactor;

    public AlchemyPotionHelper(int potionID, int tickDuration, int concentration, int durationFactor) {
        this.potionID = potionID;
        this.tickDuration = tickDuration;
        this.concentration = concentration;
        this.durationFactor = durationFactor;
    }

    public void setConcentration(int concentration) {
        this.concentration = concentration;
    }

    public void setDurationFactor(int durationFactor) {
        this.durationFactor = durationFactor;
    }

    public int getPotionID() {
        return this.potionID;
    }

    public int getTickDuration() {
        return this.tickDuration;
    }

    public int getConcentration() {
        return this.concentration;
    }

    public int getdurationFactor() {
        return this.durationFactor;
    }

    public PotionEffect getPotionEffect() {
        if (this.potionID == Potion.field_76432_h.field_76415_H || this.potionID == Potion.field_76433_i.field_76415_H) {
            return new PotionEffect(this.potionID, 1, this.concentration);
        }
        return new PotionEffect(this.potionID, (int)((double)this.tickDuration * Math.pow(0.5, this.concentration) * Math.pow(2.6666667461395264, this.durationFactor)), this.concentration);
    }

    public static AlchemyPotionHelper readEffectFromNBT(NBTTagCompound tagCompound) {
        return new AlchemyPotionHelper(tagCompound.func_74762_e("potionID"), tagCompound.func_74762_e("tickDuration"), tagCompound.func_74762_e("concentration"), tagCompound.func_74762_e("durationFactor"));
    }

    public static NBTTagCompound setEffectToNBT(AlchemyPotionHelper aph) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("potionID", aph.getPotionID());
        tagCompound.func_74768_a("tickDuration", aph.getTickDuration());
        tagCompound.func_74768_a("concentration", aph.getConcentration());
        tagCompound.func_74768_a("durationFactor", aph.getdurationFactor());
        return tagCompound;
    }
}

