/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.sacrifice;

import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import com.gamerforea.bloodmagic.EventConfig;
import com.gamerforea.bloodmagic.async.AsyncKiller;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PlayerSacrificeHandler {
    public static float scalingOfSacrifice = 0.001f;
    public static int soulFrayDuration = 400;
    public static Potion soulFrayId;

    public static float getPlayerIncense(EntityPlayer player) {
        return APISpellHelper.getCurrentIncense(player);
    }

    public static void setPlayerIncense(EntityPlayer player, float amount) {
        APISpellHelper.setCurrentIncense(player, amount);
    }

    public static boolean incrementIncense(EntityPlayer player, float min, float max, float increment) {
        float amount = PlayerSacrificeHandler.getPlayerIncense(player);
        if (amount < min || amount >= max) {
            return false;
        }
        amount += Math.min(increment, max - amount);
        PlayerSacrificeHandler.setPlayerIncense(player, amount);
        return true;
    }

    public static boolean sacrificePlayerHealth(EntityPlayer player) {
        float maxHealth;
        float health;
        if (player.func_70644_a(soulFrayId)) {
            return false;
        }
        float amount = PlayerSacrificeHandler.getPlayerIncense(player);
        if (amount >= 0.0f && (double)(health = player.func_110143_aJ()) > (double)(maxHealth = player.func_110138_aP()) / 10.0) {
            float sacrificedHealth = health - maxHealth / 10.0f;
            if (PlayerSacrificeHandler.findAndFillAltar(player.func_130014_f_(), player, (int)(sacrificedHealth * 100.0f * PlayerSacrificeHandler.getModifier(amount)))) {
                if (!EventConfig.daggerFixDeath || !AsyncKiller.INSTANCE.damage((EntityLivingBase)player, sacrificedHealth)) {
                    player.func_70606_j(maxHealth / 10.0f);
                }
                PlayerSacrificeHandler.setPlayerIncense(player, 0.0f);
                player.func_70690_d(new PotionEffect(PlayerSacrificeHandler.soulFrayId.field_76415_H, soulFrayDuration));
                return true;
            }
        }
        return false;
    }

    public static float getModifier(float amount) {
        return 1.0f + amount * scalingOfSacrifice;
    }

    public static boolean findAndFillAltar(World world, EntityPlayer player, int amount) {
        int posZ;
        int posY;
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        IBloodAltar altarEntity = PlayerSacrificeHandler.getAltar(world, posX, posY = (int)player.field_70163_u, posZ = (int)Math.round(player.field_70161_v - 0.5));
        if (altarEntity == null) {
            return false;
        }
        altarEntity.sacrificialDaggerCall(amount, false);
        altarEntity.startCycle();
        return true;
    }

    public static IBloodAltar getAltar(World world, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 1; ++k) {
                    TileEntity tileEntity = world.func_147438_o(i + x, k + y, j + z);
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }
}

