/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.armour;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.renderer.model.ModelOmegaWind;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class OmegaArmourWind
extends OmegaArmour {
    @SideOnly(value=Side.CLIENT)
    private IIcon helmetIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon plateIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leggingsIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bootsIcon;

    public OmegaArmourWind(int armorType) {
        super(armorType);
        this.storeYLevel = true;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/OmegaWind.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getChestModel() {
        return new ModelOmegaWind(1.0f, true, true, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getLegsModel() {
        return new ModelOmegaWind(0.5f, false, false, true, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
        this.helmetIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaHelmet_wind");
        this.plateIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaPlate_wind");
        this.leggingsIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaLeggings_wind");
        this.bootsIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaBoots_wind");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (this.equals(ModItems.boundHelmetWind)) {
            return this.helmetIcon;
        }
        if (this.equals(ModItems.boundPlateWind)) {
            return this.plateIcon;
        }
        if (this.equals(ModItems.boundLeggingsWind)) {
            return this.leggingsIcon;
        }
        if (this.equals(ModItems.boundBootsWind)) {
            return this.bootsIcon;
        }
        return this.field_77791_bV;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        int yLevel = this.getYLevelStored(stack);
        map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(new UUID(85212L, this.field_77881_a), "Health modifier" + this.field_77881_a, (double)(this.getDefaultArmourBoost() * this.getHealthBoostModifierForLevel(yLevel)), 1));
        map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(new UUID(86212L, this.field_77881_a), "Damage modifier" + this.field_77881_a, (double)(this.getDefaultArmourBoost() * this.getDamageModifierForLevel(yLevel)), 2));
        return map;
    }

    public float getDefaultArmourBoost() {
        switch (this.field_77881_a) {
            case 0: {
                return 2.5f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 3.5f;
            }
            case 3: {
                return 2.0f;
            }
        }
        return 0.25f;
    }

    public float getHealthBoostModifierForLevel(int yLevel) {
        return 0.05f * ((float)Math.min(yLevel, 255) / 64.0f * 1.5f - 1.0f);
    }

    public float getDamageModifierForLevel(int yLevel) {
        return 0.02f * ((float)Math.min(yLevel, 255) / 64.0f * 1.5f - 1.0f);
    }
}

