/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TESpectralBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SigilOfTheBridge
extends EnergyItems
implements ArmourUpgrade,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int tickDelay = 200;

    public SigilOfTheBridge() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilBridgeCost);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofthebridge.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofthebridge.desc2"));
        if (par1ItemStack.func_77978_p() != null) {
            if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.deactivated"));
            }
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:BridgeSigil_deactivated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:BridgeSigil_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:BridgeSigil_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound tag;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        tag.func_74757_a("isActive", !(tag = par1ItemStack.func_77978_p()).func_74767_n("isActive"));
        if (tag.func_74767_n("isActive") && EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            par1ItemStack.func_77964_b(1);
            tag.func_74768_a("worldTimeDelay", (int)(par2World.func_72820_D() - 1L) % this.tickDelay);
        } else {
            par1ItemStack.func_77964_b(par1ItemStack.func_77958_k());
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
            if (par2World.func_72820_D() % (long)this.tickDelay == (long)par1ItemStack.func_77978_p().func_74762_e("worldTimeDelay")) {
                if (EnergyItems.syphonBatteries(par1ItemStack, (EntityPlayer)par3Entity, this.getLPUsed(par1ItemStack))) {
                    this.setLPUsed(par1ItemStack, 0);
                } else {
                    par1ItemStack.func_77978_p().func_74757_a("isActive", false);
                }
            }
            if (!par3EntityPlayer.field_70122_E && !par3EntityPlayer.func_70093_af()) {
                return;
            }
            int range = 2;
            int verticalOffset = -1;
            if (par3EntityPlayer.func_70093_af()) {
                --verticalOffset;
            }
            if (par2World.field_72995_K) {
                --verticalOffset;
            }
            int posX = (int)Math.round(par3Entity.field_70165_t - 0.5);
            int posY = (int)par3Entity.field_70163_u;
            int posZ = (int)Math.round(par3Entity.field_70161_v - 0.5);
            int incremented = 0;
            for (int ix = posX - range; ix <= posX + range; ++ix) {
                for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                    TileEntity tile;
                    Block block = par2World.func_147439_a(ix, posY + verticalOffset, iz);
                    if (par2World.func_147437_c(ix, posY + verticalOffset, iz)) {
                        par2World.func_147465_d(ix, posY + verticalOffset, iz, ModBlocks.spectralBlock, 0, 3);
                        tile = par2World.func_147438_o(ix, posY + verticalOffset, iz);
                        if (tile instanceof TESpectralBlock) {
                            ((TESpectralBlock)tile).setDuration(100);
                        }
                        if (par2World.field_73012_v.nextInt(2) != 0) continue;
                        ++incremented;
                        continue;
                    }
                    if (block != ModBlocks.spectralBlock || !((tile = par2World.func_147438_o(ix, posY + verticalOffset, iz)) instanceof TESpectralBlock)) continue;
                    ((TESpectralBlock)tile).setDuration(100);
                }
            }
            this.incrimentLPUSed(par1ItemStack, incremented);
        }
    }

    public int getLPUsed(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74762_e("LPUsed");
    }

    public void incrimentLPUSed(ItemStack par1ItemStack, int addedLP) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74768_a("LPUsed", par1ItemStack.func_77978_p().func_74762_e("LPUsed") + addedLP);
    }

    public void setLPUsed(ItemStack par1ItemStack, int newLP) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74768_a("LPUsed", newLP);
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        if (!player.field_70122_E && !player.func_70093_af()) {
            return;
        }
        int range = 2;
        int verticalOffset = -2;
        if (player.func_70093_af()) {
            --verticalOffset;
        }
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        int posY = (int)player.field_70163_u;
        int posZ = (int)Math.round(player.field_70161_v - 0.5);
        for (int ix = posX - range; ix <= posX + range; ++ix) {
            for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                TileEntity tile;
                Block block = world.func_147439_a(ix, posY + verticalOffset, iz);
                if (world.func_147437_c(ix, posY + verticalOffset, iz)) {
                    world.func_147465_d(ix, posY + verticalOffset, iz, ModBlocks.spectralBlock, 0, 3);
                    tile = world.func_147438_o(ix, posY + verticalOffset, iz);
                    if (!(tile instanceof TESpectralBlock)) continue;
                    ((TESpectralBlock)tile).setDuration(100);
                    continue;
                }
                if (block != ModBlocks.spectralBlock || !((tile = world.func_147438_o(ix, posY + verticalOffset, iz)) instanceof TESpectralBlock)) continue;
                ((TESpectralBlock)tile).setDuration(100);
            }
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 100;
    }
}

