/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.bloodmagic.async;

import com.gamerforea.bloodmagic.EventConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.iterator.TObjectFloatIterator;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public final class AsyncKiller {
    public static final AsyncKiller INSTANCE = new AsyncKiller();
    private final TObjectFloatMap<EntityLivingBase> directDamages = new TObjectFloatHashMap();
    private final TObjectFloatMap<EntityLivingBase> damages = new TObjectFloatHashMap();

    public static void init() {
        if (EventConfig.asyncDeath) {
            FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        }
    }

    public boolean damage(EntityLivingBase entity, float damage) {
        if (EventConfig.asyncDeath) {
            boolean contains;
            if (!entity.field_70170_p.field_72995_K && !(contains = this.damages.adjustValue((Object)entity, damage))) {
                this.damages.put((Object)entity, damage);
            }
            return true;
        }
        return false;
    }

    public boolean damageDirect(EntityLivingBase entity, float damage) {
        if (EventConfig.asyncDeath) {
            boolean contains;
            if (!entity.field_70170_p.field_72995_K && !(contains = this.directDamages.adjustValue((Object)entity, damage))) {
                this.directDamages.put((Object)entity, damage);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            float damage;
            EntityLivingBase entity;
            TObjectFloatIterator iterator;
            if (!this.directDamages.isEmpty()) {
                iterator = this.directDamages.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    entity = (EntityLivingBase)iterator.key();
                    damage = iterator.value();
                    if (entity.field_70128_L) continue;
                    if (EventConfig.asyncDeathSafe) {
                        entity.func_70097_a(DamageSource.field_76377_j, damage);
                        continue;
                    }
                    float health = entity.func_110143_aJ();
                    if (health <= 5.0E-4f) continue;
                    entity.func_70606_j(Math.max(health - damage, 0.0f));
                    if (!(entity.func_110143_aJ() <= 5.0E-4f)) continue;
                    entity.func_70645_a(DamageSource.field_76377_j);
                }
                this.directDamages.clear();
            }
            if (!this.damages.isEmpty()) {
                iterator = this.damages.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    entity = (EntityLivingBase)iterator.key();
                    damage = iterator.value();
                    if (entity.field_70128_L) continue;
                    entity.func_70097_a(DamageSource.field_76377_j, damage);
                }
                this.damages.clear();
            }
        }
    }
}

