/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.slope.SlopeType;
import com.carpentersblocks.util.slope.SlopeTypeFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Slope {
    public static final byte ID_WEDGE_SE = 0;
    public static final byte ID_WEDGE_NW = 1;
    public static final byte ID_WEDGE_NE = 2;
    public static final byte ID_WEDGE_SW = 3;
    public static final byte ID_WEDGE_NEG_N = 4;
    public static final byte ID_WEDGE_NEG_S = 5;
    public static final byte ID_WEDGE_NEG_W = 6;
    public static final byte ID_WEDGE_NEG_E = 7;
    public static final byte ID_WEDGE_POS_N = 8;
    public static final byte ID_WEDGE_POS_S = 9;
    public static final byte ID_WEDGE_POS_W = 10;
    public static final byte ID_WEDGE_POS_E = 11;
    public static final byte ID_WEDGE_INT_NEG_SE = 12;
    public static final byte ID_WEDGE_INT_NEG_NW = 13;
    public static final byte ID_WEDGE_INT_NEG_NE = 14;
    public static final byte ID_WEDGE_INT_NEG_SW = 15;
    public static final byte ID_WEDGE_INT_POS_SE = 16;
    public static final byte ID_WEDGE_INT_POS_NW = 17;
    public static final byte ID_WEDGE_INT_POS_NE = 18;
    public static final byte ID_WEDGE_INT_POS_SW = 19;
    public static final byte ID_WEDGE_EXT_NEG_SE = 20;
    public static final byte ID_WEDGE_EXT_NEG_NW = 21;
    public static final byte ID_WEDGE_EXT_NEG_NE = 22;
    public static final byte ID_WEDGE_EXT_NEG_SW = 23;
    public static final byte ID_WEDGE_EXT_POS_SE = 24;
    public static final byte ID_WEDGE_EXT_POS_NW = 25;
    public static final byte ID_WEDGE_EXT_POS_NE = 26;
    public static final byte ID_WEDGE_EXT_POS_SW = 27;
    public static final byte ID_OBL_INT_NEG_SE = 28;
    public static final byte ID_OBL_INT_NEG_NW = 29;
    public static final byte ID_OBL_INT_NEG_NE = 30;
    public static final byte ID_OBL_INT_NEG_SW = 31;
    public static final byte ID_OBL_INT_POS_SE = 32;
    public static final byte ID_OBL_INT_POS_NW = 33;
    public static final byte ID_OBL_INT_POS_NE = 34;
    public static final byte ID_OBL_INT_POS_SW = 35;
    public static final byte ID_OBL_EXT_NEG_SE = 36;
    public static final byte ID_OBL_EXT_NEG_NW = 37;
    public static final byte ID_OBL_EXT_NEG_NE = 38;
    public static final byte ID_OBL_EXT_NEG_SW = 39;
    public static final byte ID_OBL_EXT_POS_SE = 40;
    public static final byte ID_OBL_EXT_POS_NW = 41;
    public static final byte ID_OBL_EXT_POS_NE = 42;
    public static final byte ID_OBL_EXT_POS_SW = 43;
    public static final byte ID_PRISM_NEG = 44;
    public static final byte ID_PRISM_POS = 45;
    public static final byte ID_PRISM_1P_POS_N = 46;
    public static final byte ID_PRISM_1P_POS_S = 47;
    public static final byte ID_PRISM_1P_POS_W = 48;
    public static final byte ID_PRISM_1P_POS_E = 49;
    public static final byte ID_PRISM_2P_POS_NS = 50;
    public static final byte ID_PRISM_2P_POS_WE = 51;
    public static final byte ID_PRISM_2P_POS_SE = 52;
    public static final byte ID_PRISM_2P_POS_NW = 53;
    public static final byte ID_PRISM_2P_POS_NE = 54;
    public static final byte ID_PRISM_2P_POS_SW = 55;
    public static final byte ID_PRISM_3P_POS_NWE = 56;
    public static final byte ID_PRISM_3P_POS_SWE = 57;
    public static final byte ID_PRISM_3P_POS_NSW = 58;
    public static final byte ID_PRISM_3P_POS_NSE = 59;
    public static final byte ID_PRISM_POS_4P = 60;
    public static final byte ID_PRISM_WEDGE_POS_N = 61;
    public static final byte ID_PRISM_WEDGE_POS_S = 62;
    public static final byte ID_PRISM_WEDGE_POS_W = 63;
    public static final byte ID_PRISM_WEDGE_POS_E = 64;
    private static final byte[][] ROTATION_Y = new byte[][]{{2, 3, 1, 0, 6, 7, 5, 4, 10, 11, 9, 8, 14, 15, 13, 12, 18, 19, 17, 16, 22, 23, 21, 20, 26, 27, 25, 24, 30, 31, 29, 28, 34, 35, 33, 32, 38, 39, 37, 36, 42, 43, 41, 40, 44, 45, 48, 49, 47, 46, 51, 50, 54, 55, 53, 52, 58, 59, 57, 56, 60, 63, 64, 62, 61}, {3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13, 19, 18, 16, 17, 23, 22, 20, 21, 27, 26, 24, 25, 31, 30, 28, 29, 35, 34, 32, 33, 39, 38, 36, 37, 43, 42, 40, 41, 44, 45, 49, 48, 46, 47, 51, 50, 55, 54, 52, 53, 59, 58, 56, 57, 60, 64, 63, 61, 62}};
    public static final byte XYNN = 1;
    public static final byte XYNP = 2;
    public static final byte XYPN = 3;
    public static final byte XYPP = 4;
    private static final Slope[] slopesList = new Slope[65];
    public final int slopeID;
    public final SlopeType slopeType;
    public final Type type;
    private final Face[] face;
    private final int[] faceBias;
    public final boolean isPositive;
    public final List<ForgeDirection> facings;
    public static final Slope WEDGE_NW = new Slope(1, Type.WEDGE_SIDE, new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.WEDGE, Face.NONE, Face.FULL, Face.NONE, Face.FULL}, new int[]{4, 4, 0, 0, 0, 0});
    public static final Slope WEDGE_NE = new Slope(2, Type.WEDGE_SIDE, new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.WEDGE, Face.NONE, Face.FULL, Face.FULL, Face.NONE}, new int[]{2, 2, 0, 0, 0, 0});
    public static final Slope WEDGE_SW = new Slope(3, Type.WEDGE_SIDE, new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.WEDGE, Face.FULL, Face.NONE, Face.NONE, Face.FULL}, new int[]{3, 3, 0, 0, 0, 0});
    public static final Slope WEDGE_SE = new Slope(0, Type.WEDGE_SIDE, new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.WEDGE, Face.FULL, Face.NONE, Face.FULL, Face.NONE}, new int[]{1, 1, 0, 0, 0, 0});
    public static final Slope WEDGE_NEG_N = new Slope(4, Type.WEDGE, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH}, new Face[]{Face.NONE, Face.FULL, Face.NONE, Face.FULL, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 4, 4});
    public static final Slope WEDGE_NEG_S = new Slope(5, Type.WEDGE, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH}, new Face[]{Face.NONE, Face.FULL, Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 2, 2});
    public static final Slope WEDGE_NEG_W = new Slope(6, Type.WEDGE, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.WEDGE, Face.NONE, Face.FULL}, new int[]{0, 0, 4, 4, 0, 0});
    public static final Slope WEDGE_NEG_E = new Slope(7, Type.WEDGE, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL, Face.NONE}, new int[]{0, 0, 2, 2, 0, 0});
    public static final Slope WEDGE_POS_N = new Slope(8, Type.WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.FULL, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 3, 3});
    public static final Slope WEDGE_POS_S = new Slope(9, Type.WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH}, new Face[]{Face.FULL, Face.NONE, Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 1, 1});
    public static final Slope WEDGE_POS_W = new Slope(10, Type.WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE, Face.FULL}, new int[]{0, 0, 3, 3, 0, 0});
    public static final Slope WEDGE_POS_E = new Slope(11, Type.WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE, Face.FULL, Face.NONE}, new int[]{0, 0, 1, 1, 0, 0});
    public static final Slope WEDGE_INT_NEG_NW = new Slope(13, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL}, new int[]{0, 0, 4, 0, 4, 0});
    public static final Slope WEDGE_INT_NEG_NE = new Slope(14, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE}, new int[]{0, 0, 2, 0, 0, 4});
    public static final Slope WEDGE_INT_NEG_SW = new Slope(15, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.FULL, Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL}, new int[]{0, 0, 0, 4, 2, 0});
    public static final Slope WEDGE_INT_NEG_SE = new Slope(12, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.FULL, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE}, new int[]{0, 0, 0, 2, 0, 2});
    public static final Slope WEDGE_INT_POS_NW = new Slope(17, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL}, new int[]{0, 0, 3, 0, 3, 0});
    public static final Slope WEDGE_INT_POS_NE = new Slope(18, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE}, new int[]{0, 0, 1, 0, 0, 3});
    public static final Slope WEDGE_INT_POS_SW = new Slope(19, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL}, new int[]{0, 0, 0, 3, 1, 0});
    public static final Slope WEDGE_INT_POS_SE = new Slope(16, Type.WEDGE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE}, new int[]{0, 0, 0, 1, 0, 1});
    public static final Slope WEDGE_EXT_NEG_NW = new Slope(21, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.FULL, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE}, new int[]{0, 0, 0, 4, 0, 4});
    public static final Slope WEDGE_EXT_NEG_NE = new Slope(22, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE}, new int[]{0, 0, 0, 2, 4, 0});
    public static final Slope WEDGE_EXT_NEG_SW = new Slope(23, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE}, new int[]{0, 0, 4, 0, 0, 2});
    public static final Slope WEDGE_EXT_NEG_SE = new Slope(20, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.FULL, Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE}, new int[]{0, 0, 2, 0, 2, 0});
    public static final Slope WEDGE_EXT_POS_NW = new Slope(25, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE}, new int[]{0, 0, 0, 3, 0, 3});
    public static final Slope WEDGE_EXT_POS_NE = new Slope(26, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE}, new int[]{0, 0, 0, 1, 3, 0});
    public static final Slope WEDGE_EXT_POS_SW = new Slope(27, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE}, new int[]{0, 0, 3, 0, 0, 1});
    public static final Slope WEDGE_EXT_POS_SE = new Slope(24, Type.WEDGE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE}, new int[]{0, 0, 1, 0, 1, 0});
    public static final Slope OBL_INT_NEG_NW = new Slope(29, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL}, new int[]{4, 0, 4, 0, 4, 0});
    public static final Slope OBL_INT_NEG_NE = new Slope(30, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE}, new int[]{2, 0, 2, 0, 0, 4});
    public static final Slope OBL_INT_NEG_SW = new Slope(31, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL}, new int[]{3, 0, 0, 4, 2, 0});
    public static final Slope OBL_INT_NEG_SE = new Slope(28, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE}, new int[]{1, 0, 0, 2, 0, 2});
    public static final Slope OBL_INT_POS_NW = new Slope(33, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL}, new int[]{0, 4, 3, 0, 3, 0});
    public static final Slope OBL_INT_POS_NE = new Slope(34, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL, Face.FULL, Face.WEDGE}, new int[]{0, 2, 1, 0, 0, 3});
    public static final Slope OBL_INT_POS_SW = new Slope(35, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE, Face.WEDGE, Face.FULL}, new int[]{0, 3, 0, 3, 1, 0});
    public static final Slope OBL_INT_POS_SE = new Slope(32, Type.OBLIQUE_INT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE, Face.FULL, Face.WEDGE}, new int[]{0, 1, 0, 1, 0, 1});
    public static final Slope OBL_EXT_NEG_NW = new Slope(37, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE}, new int[]{0, 4, 0, 4, 0, 4});
    public static final Slope OBL_EXT_NEG_NE = new Slope(38, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE}, new int[]{0, 2, 0, 2, 4, 0});
    public static final Slope OBL_EXT_NEG_SW = new Slope(39, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE}, new int[]{0, 3, 4, 0, 0, 2});
    public static final Slope OBL_EXT_NEG_SE = new Slope(36, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE}, new int[]{0, 1, 2, 0, 2, 0});
    public static final Slope OBL_EXT_POS_NW = new Slope(41, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE}, new int[]{4, 0, 0, 3, 0, 3});
    public static final Slope OBL_EXT_POS_NE = new Slope(42, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE, Face.WEDGE, Face.NONE}, new int[]{2, 0, 0, 1, 3, 0});
    public static final Slope OBL_EXT_POS_SW = new Slope(43, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE, Face.NONE, Face.WEDGE}, new int[]{3, 0, 3, 0, 0, 1});
    public static final Slope OBL_EXT_POS_SE = new Slope(40, Type.OBLIQUE_EXT, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE, Face.WEDGE, Face.NONE}, new int[]{1, 0, 1, 0, 1, 0});
    public static final Slope PRISM_NEG = new Slope(44, Type.PRISM, new ForgeDirection[]{ForgeDirection.DOWN}, new Face[]{Face.NONE, Face.FULL, Face.NONE, Face.NONE, Face.NONE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_POS = new Slope(45, Type.PRISM, new ForgeDirection[]{ForgeDirection.UP}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.NONE, Face.NONE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_1P_POS_N = new Slope(46, Type.PRISM_1P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.NONE, Face.NONE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_1P_POS_S = new Slope(47, Type.PRISM_1P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.TRIANGLE, Face.NONE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_1P_POS_W = new Slope(48, Type.PRISM_1P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.NONE, Face.TRIANGLE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_1P_POS_E = new Slope(49, Type.PRISM_1P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.NONE, Face.NONE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_NS = new Slope(50, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.NONE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_WE = new Slope(51, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.NONE, Face.TRIANGLE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_SE = new Slope(52, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.TRIANGLE, Face.NONE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_NW = new Slope(53, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.NONE, Face.TRIANGLE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_NE = new Slope(54, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.NONE, Face.NONE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_2P_POS_SW = new Slope(55, Type.PRISM_2P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_3P_POS_WEN = new Slope(56, Type.PRISM_3P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.NONE, Face.TRIANGLE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_3P_POS_WES = new Slope(57, Type.PRISM_3P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_3P_POS_NSW = new Slope(58, Type.PRISM_3P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.TRIANGLE, Face.NONE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_3P_POS_NSE = new Slope(59, Type.PRISM_3P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.NONE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_4P_POS = new Slope(60, Type.PRISM_4P, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.TRIANGLE, Face.TRIANGLE, Face.TRIANGLE}, new int[]{0, 0, 0, 0, 0, 0});
    public static final Slope PRISM_WEDGE_POS_N = new Slope(61, Type.PRISM_WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH}, new Face[]{Face.FULL, Face.NONE, Face.TRIANGLE, Face.FULL, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 3, 3});
    public static final Slope PRISM_WEDGE_POS_S = new Slope(62, Type.PRISM_WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH}, new Face[]{Face.FULL, Face.NONE, Face.FULL, Face.TRIANGLE, Face.WEDGE, Face.WEDGE}, new int[]{0, 0, 0, 0, 1, 1});
    public static final Slope PRISM_WEDGE_POS_W = new Slope(63, Type.PRISM_WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.WEST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE, Face.TRIANGLE, Face.FULL}, new int[]{0, 0, 3, 3, 0, 0});
    public static final Slope PRISM_WEDGE_POS_E = new Slope(64, Type.PRISM_WEDGE, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.EAST}, new Face[]{Face.FULL, Face.NONE, Face.WEDGE, Face.WEDGE, Face.FULL, Face.TRIANGLE}, new int[]{0, 0, 1, 1, 0, 0});

    private Slope(int slopeID, Type slopeType, ForgeDirection[] facings, Face[] faceShape, int[] faceBias) {
        this.slopeID = slopeID;
        Slope.slopesList[slopeID] = this;
        this.type = slopeType;
        this.slopeType = SlopeTypeFactory.getInstance().getSlope(this.type);
        this.face = faceShape;
        this.faceBias = faceBias;
        this.facings = new ArrayList<ForgeDirection>();
        for (ForgeDirection face : facings) {
            this.facings.add(face);
        }
        this.isPositive = this.facings.contains(ForgeDirection.UP);
    }

    public Type getPrimaryType() {
        switch (this.type) {
            case PRISM: 
            case PRISM_1P: 
            case PRISM_2P: 
            case PRISM_3P: 
            case PRISM_4P: {
                return Type.PRISM;
            }
        }
        return this.type;
    }

    public Face getFace(ForgeDirection side) {
        return this.face[side.ordinal()];
    }

    public boolean isFaceFull(ForgeDirection side) {
        return this.face[side.ordinal()] == Face.FULL;
    }

    public boolean hasSide(ForgeDirection side) {
        return this.face[side.ordinal()] != Face.NONE;
    }

    public int getFaceBias(ForgeDirection side) {
        return this.faceBias[side.ordinal()];
    }

    public static Slope getSlope(TEBase TE) {
        int slopeID = TE.getData();
        if (slopeID >= slopesList.length) {
            ModLogger.info("Detected abnormal slope data, adjusting to safe value.", new Object[0]);
            slopeID = 0;
            TE.setData(0);
        }
        return slopesList[slopeID];
    }

    public static Slope getSlopeById(int slopeID) {
        if (slopeID >= slopesList.length) {
            slopeID = 0;
        }
        return slopesList[slopeID];
    }

    public static boolean rotate(World world, int x, int y, int z, ForgeDirection axis) {
        TEBase TE = BlockProperties.getTileEntity(BlockRegistry.blockCarpentersSlope, world, x, y, z);
        if (TE != null) {
            int data = TE.getData();
            if (axis.offsetY == 0) {
                return false;
            }
            if (data >= slopesList.length) {
                ModLogger.info("Detected abnormal slope data at (%d,%d,%d), resetting to default.", x, y, z);
                TE.setData(0);
                return false;
            }
            byte newData = ROTATION_Y[axis.ordinal()][data];
            TE.setData(newData);
            return true;
        }
        return false;
    }

    public static enum Face {
        NONE,
        FULL,
        WEDGE,
        TRIANGLE;

    }

    public static enum Type {
        WEDGE_SIDE,
        WEDGE,
        WEDGE_INT,
        WEDGE_EXT,
        OBLIQUE_INT,
        OBLIQUE_EXT,
        PRISM,
        PRISM_1P,
        PRISM_2P,
        PRISM_3P,
        PRISM_4P,
        PRISM_WEDGE;

    }
}

