/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util;

import com.carpentersblocks.util.ModLogger;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class Attribute {
    private static final String TAG_UNIQUE_ID = "cbUniqueId";
    private ItemStack _itemStack;
    private String _uniqueId;
    private boolean _error;

    public Attribute(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != null) {
            this._itemStack = itemStack;
            this._uniqueId = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b()).toString();
        }
    }

    public ItemStack getItemStack() {
        return this._itemStack;
    }

    public String getUniqueId() {
        return this._uniqueId;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this._itemStack.func_77955_b(nbt);
        nbt.func_74778_a(TAG_UNIQUE_ID, this._uniqueId);
        return nbt;
    }

    public static Attribute loadAttributeFromNBT(NBTTagCompound nbt) {
        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbt);
        if (itemStack == null) {
            GameRegistry.UniqueIdentifier uniqueId = new GameRegistry.UniqueIdentifier(nbt.func_74779_i(TAG_UNIQUE_ID));
            itemStack = GameRegistry.findItemStack((String)uniqueId.modId, (String)uniqueId.name, (int)1);
            if (itemStack != null) {
                short dmg = nbt.func_74765_d("Damage");
                itemStack.func_77964_b((int)dmg);
                ModLogger.log(Level.WARN, "Invalid Id for attribute '" + uniqueId.toString() + "' corrected.", new Object[0]);
            } else {
                ModLogger.log(Level.WARN, "Block attribute '" + uniqueId.toString() + "' was unable to be recovered. Was a mod removed?", new Object[0]);
            }
        }
        return new Attribute(itemStack);
    }
}

