/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.network.message;

import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import team.chisel.Chisel;
import team.chisel.client.GeneralChiselClient;
import team.chisel.item.chisel.ItemChisel;
import team.chisel.network.message.base.MessageCoords;

public class MessageChiselSound
extends MessageCoords {
    private int block;
    private byte meta;
    private boolean breakChisel;

    public MessageChiselSound() {
    }

    public MessageChiselSound(int x, int y, int z, ICarvingVariation v, boolean breakChisel) {
        super(x, y, z);
        this.block = Block.func_149682_b((Block)v.getBlock());
        this.meta = (byte)v.getBlockMeta();
        this.breakChisel = breakChisel;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.block);
        buf.writeByte((int)this.meta);
        buf.writeBoolean(this.breakChisel);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.block = buf.readInt();
        this.meta = buf.readByte();
        this.breakChisel = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<MessageChiselSound, IMessage> {
        public IMessage onMessage(MessageChiselSound message, MessageContext ctx) {
            String sound = ItemChisel.carving.getVariationSound(Block.func_149729_e((int)message.block), (int)message.meta);
            GeneralChiselClient.spawnChiselEffect(message.x, message.y, message.z, sound);
            if (message.breakChisel) {
                EntityPlayer player = Chisel.proxy.getClientPlayer();
                player.func_70669_a(player.func_71045_bC());
            }
            return null;
        }
    }
}

