/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.core.ProxyClient;
import cofh.core.render.customcharrendering.ICustomCharRenderer;
import cofh.core.render.customcharrendering.RenderPlayerFace;
import cofh.core.render.customcharrendering.RenderSprite;
import cofh.lib.util.helpers.SecurityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TCharObjectHashMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class CoFHFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    public final TCharObjectHashMap<ICustomCharRenderer> renderOverrides = new TCharObjectHashMap();
    private char n = (char)888;

    public CoFHFontRenderer(GameSettings gameSettings, ResourceLocation resourceLocation, TextureManager textureManager, boolean b) {
        super(gameSettings, resourceLocation, textureManager, b);
    }

    public int func_78256_a(String s) {
        if (s == null) {
            return 0;
        }
        int n = 0;
        boolean b = false;
        for (int i = 0; i < s.length(); ++i) {
            int charWidth = this.func_78263_a(s.charAt(i));
            if (charWidth < 0 && i < s.length() - 1) {
                char char1;
                if ((char1 = s.charAt(++i)) != 'l' && char1 != 'L') {
                    if (char1 == 'r' || char1 == 'R') {
                        b = false;
                    }
                } else {
                    b = true;
                }
                charWidth = 0;
            }
            n += charWidth;
            if (!b) continue;
            ++n;
        }
        return n;
    }

    public String func_78269_a(String s, int n) {
        return this.func_78262_a(s, n, false);
    }

    public List<String> func_78271_c(String s, int n) {
        return Arrays.asList(this.func_78280_d(s, n).split("\n"));
    }

    public String func_78280_d(String s, int n) {
        int sizeStringToWidth = this.func_78259_e(s, n);
        if (s.length() <= sizeStringToWidth) {
            return s;
        }
        String substring = s.substring(0, sizeStringToWidth);
        char char1 = s.charAt(sizeStringToWidth);
        return substring + "\n" + this.func_78280_d(CoFHFontRenderer.getFormatFromString(substring) + s.substring(sizeStringToWidth + (char1 == ' ' || char1 == '\n' ? 1 : 0)), n);
    }

    public int func_78259_e(String s, int n) {
        int i;
        int length = s.length();
        int n2 = 0;
        int n3 = -1;
        boolean b = false;
        for (i = 0; i < length; ++i) {
            char char1 = s.charAt(i);
            switch (char1) {
                case '\n': {
                    --i;
                    break;
                }
                case '\u00a7': {
                    char char2;
                    if (i >= length - 1) break;
                    if ((char2 = s.charAt(++i)) != 'l' && char2 != 'L') {
                        if (char2 != 'r' && char2 != 'R' && !CoFHFontRenderer.isFormatColor(char2)) break;
                        b = false;
                        break;
                    }
                    b = true;
                    break;
                }
                case ' ': {
                    n3 = i;
                }
                default: {
                    n2 += this.func_78263_a(char1);
                    if (!b) break;
                    ++n2;
                }
            }
            if (char1 == '\n') {
                n3 = ++i;
                break;
            }
            if (n2 > n) break;
        }
        return i != length && n3 != -1 && n3 < i ? n3 : i;
    }

    public static String getFormatFromString(String s) {
        String str = "";
        int index = -1;
        int length = s.length();
        while ((index = s.indexOf(167, index + 1)) != -1) {
            if (index >= length - 1) continue;
            char char1 = s.charAt(index + 1);
            if (CoFHFontRenderer.isFormatColor(char1)) {
                str = "\u0e22\u0e07" + char1;
                continue;
            }
            if (!CoFHFontRenderer.isFormatSpecial(char1)) continue;
            str = str + "\u0e22\u0e07" + char1;
        }
        return str;
    }

    public static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isFormatSpecial(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R';
    }

    public void resetColor() {
        super.setColor(this.r, this.g, this.b, this.a);
    }

    public void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        super.setColor(this.r, this.g, this.b, this.a);
    }

    public float func_78277_a(char c, boolean b) {
        float renderChar;
        ICustomCharRenderer customCharRenderer = (ICustomCharRenderer)this.renderOverrides.get(c);
        if (customCharRenderer != null && (renderChar = customCharRenderer.renderChar(c, b, this.field_78295_j, this.field_78296_k, this)) != -2.0f) {
            return renderChar;
        }
        return super.func_78277_a(c, b);
    }

    public int func_78263_a(char c) {
        int charWidth;
        ICustomCharRenderer customCharRenderer = (ICustomCharRenderer)this.renderOverrides.get(c);
        if (customCharRenderer != null && (charWidth = customCharRenderer.getCharWidth(c, this)) != -2) {
            return charWidth;
        }
        return super.func_78263_a(c);
    }

    public void initSpecialCharacters() {
        RenderSprite.addRenderer('\u2661', Gui.field_110324_m, 52, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2665', Gui.field_110324_m, 124, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2314', Gui.field_110324_m, 34, 9, 9, 9, this);
        RenderSprite.addRenderer('\u25cb', Gui.field_110324_m, 16, 18, 9, 9, this);
        RenderSprite.addRenderer('\u25cc', Gui.field_110324_m, 25, 18, 9, 9, this);
        RenderSprite.addRenderer('\u29f0', Gui.field_110324_m, 52, 27, 9, 9, this);
        RenderSprite.addRenderer('\u2763', Gui.field_110324_m, 52, 45, 9, 9, this);
        ResourceLocation resourceLocation = new ResourceLocation("textures/gui/container/beacon.png");
        RenderSprite.addRenderer('\u2715', resourceLocation, 113, 222, 15, 15, this);
        RenderSprite.addRenderer('\u2714', resourceLocation, 90, 223, 16, 14, this);
        RenderPlayerFace.init(this);
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
    }

    public static FontRenderer loadFontRendererStack(ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            return RenderPlayerFace.loadProfile(itemStack);
        }
        return ProxyClient.fontRenderer;
    }

    public char getNextBlankChar() {
        this.n = (char)(this.n + '\u0001');
        while (this.field_78287_e[this.n] != 0 && this.renderOverrides.containsKey(this.n)) {
            this.n = (char)(this.n + '\u0001');
        }
        return this.n;
    }
}

