/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.IRedstoneControl;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RedstoneControlHelper {
    private RedstoneControlHelper() {
    }

    public static NBTTagCompound setItemStackTagRS(NBTTagCompound nBTTagCompound, IRedstoneControl iRedstoneControl) {
        if (iRedstoneControl == null) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        nBTTagCompound.func_74774_a("RSControl", (byte)iRedstoneControl.getControl().ordinal());
        return nBTTagCompound;
    }

    public static IRedstoneControl.ControlMode getControlFromNBT(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[nBTTagCompound.func_74771_c("RSControl")];
    }

    public static void addRSControlInformation(ItemStack itemStack, List<String> list) {
        if (RedstoneControlHelper.hasRSControl(itemStack)) {
            switch (itemStack.field_77990_d.func_74771_c("RSControl")) {
                case 0: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a74" + StringHelper.localize("info.cofh.disabled") + "\u00a7r");
                    return;
                }
                case 1: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a7a" + StringHelper.localize("info.cofh.enabled") + "\u00a77" + ", " + StringHelper.localize("info.cofh.low") + "\u00a7r");
                    return;
                }
                case 2: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a7a" + StringHelper.localize("info.cofh.enabled") + "\u00a77" + ", " + StringHelper.localize("info.cofh.high") + "\u00a7r");
                    return;
                }
            }
        }
    }

    public static boolean hasRSControl(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74764_b("RSControl");
    }

    public static boolean setControl(ItemStack itemStack, IRedstoneControl.ControlMode controlMode) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74774_a("RSControl", (byte)controlMode.ordinal());
        return true;
    }

    public static IRedstoneControl.ControlMode getControl(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[itemStack.field_77990_d.func_74771_c("RSControl")];
    }
}

