/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;

public class SecurityHelper {
    public static final GameProfile UNKNOWN_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static boolean setup = false;
    private static UUID cachedId;

    public static void setup() {
        if (!setup) {
            EnumConnectionState.PLAY.func_150755_b().put((Object)-26, Login.S__PacketSendUUID.class);
            Map var0 = (Map)ReflectionHelper.getPrivateValue(EnumConnectionState.class, (Object)null, (String[])new String[]{"field_150761_f"});
            var0.put(Login.S__PacketSendUUID.class, EnumConnectionState.PLAY);
            FMLCommonHandler.instance().bus().register((Object)new Login.S__PacketSendUUID());
            setup = true;
        }
    }

    public static boolean isDefaultUUID(UUID var0) {
        return var0 == null || var0.version() == 4 && var0.variant() == 0;
    }

    public static UUID getID(EntityPlayer var0) {
        return MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71278_l() ? var0.func_146103_bH().getId() : SecurityHelper.getClientId(var0);
    }

    private static UUID getClientId(EntityPlayer var0) {
        if (var0 != Minecraft.func_71410_x().field_71439_g) {
            return var0.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound var0, ISecurable var1) {
        if (var1 == null) {
            return null;
        }
        if (var0 == null) {
            var0 = new NBTTagCompound();
        }
        var0.func_74757_a("Secure", true);
        var0.func_74774_a("Access", (byte)var1.getAccess().ordinal());
        var0.func_74778_a("OwnerUUID", var1.getOwner().getId().toString());
        var0.func_74778_a("Owner", var1.getOwner().getName());
        return var0;
    }

    public static void addOwnerInformation(ItemStack var0, List<String> var1) {
        if (SecurityHelper.isSecure(var0)) {
            boolean var2 = var0.field_77990_d.func_74764_b("OwnerUUID");
            if (!var0.field_77990_d.func_74764_b("Owner") && !var2) {
                var1.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (var2 && var0.field_77990_d.func_74764_b("Owner")) {
                var1.add(StringHelper.localize("info.cofh.owner") + ": " + var0.field_77990_d.func_74779_i("Owner"));
            } else {
                var1.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack var0, List<String> var1) {
        if (SecurityHelper.isSecure(var0)) {
            String var2 = "";
            switch (var0.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    var2 = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    var2 = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    var2 = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            var1.add(StringHelper.localize("info.cofh.access") + ": " + var2);
        }
    }

    public static boolean isSecure(ItemStack var0) {
        return var0.field_77990_d == null ? false : var0.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack var0) {
        if (SecurityHelper.isSecure(var0)) {
            return var0;
        }
        if (var0.field_77990_d == null) {
            var0.func_77982_d(new NBTTagCompound());
        }
        var0.field_77990_d.func_74757_a("Secure", true);
        var0.field_77990_d.func_74774_a("Access", (byte)0);
        return var0;
    }

    public static ItemStack removeSecure(ItemStack var0) {
        if (!SecurityHelper.isSecure(var0)) {
            return var0;
        }
        var0.field_77990_d.func_82580_o("Secure");
        var0.field_77990_d.func_82580_o("Access");
        var0.field_77990_d.func_82580_o("OwnerUUID");
        var0.field_77990_d.func_82580_o("Owner");
        if (var0.field_77990_d.func_82582_d()) {
            var0.field_77990_d = null;
        }
        return var0;
    }

    public static boolean setAccess(ItemStack var0, ISecurable.AccessMode var1) {
        if (!SecurityHelper.isSecure(var0)) {
            return false;
        }
        var0.field_77990_d.func_74774_a("Access", (byte)var1.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack var0) {
        return var0.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[var0.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwner(ItemStack var0, GameProfile var1) {
        if (!SecurityHelper.isSecure(var0)) {
            return false;
        }
        var0.func_77983_a("OwnerUUID", (NBTBase)new NBTTagString(var1.getId().toString()));
        var0.func_77983_a("Owner", (NBTBase)new NBTTagString(var1.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack var0) {
        if (var0.field_77990_d != null) {
            NBTTagCompound var1 = var0.field_77990_d;
            String var2 = var1.func_74779_i("OwnerUUID");
            String var3 = var1.func_74779_i("Owner");
            if (!Strings.isNullOrEmpty((String)var2)) {
                return new GameProfile(UUID.fromString(var2), var3);
            }
            if (!Strings.isNullOrEmpty((String)var3)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_152719_a((String)var3)), var3);
            }
        }
        return UNKNOWN_GAME_PROFILE;
    }

    public static GameProfile getProfile(UUID var0, String var1) {
        GameProfile var2 = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(var0);
        if (var2 == null) {
            GameProfile var3 = new GameProfile(var0, var1);
            var2 = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(var3, true);
            if (var2 != var3) {
                MinecraftServer.func_71276_C().func_152358_ax().func_152649_a(var2);
            }
        }
        return var2;
    }

    public static String getOwnerName(ItemStack var0) {
        boolean var2;
        NBTTagCompound var1 = var0.field_77990_d;
        return var1 != null && ((var2 = var1.func_74764_b("OwnerUUID")) || var1.func_74764_b("Owner")) ? (var2 ? var0.field_77990_d.func_74779_i("Owner") : StringHelper.localize("info.cofh.anotherplayer")) : "[None]";
    }

    static {
        SecurityHelper.setup();
    }

    private static class Login {
        private Login() {
        }

        public static class S__PacketSendUUID
        extends Packet {
            private UUID id;

            @SubscribeEvent
            public void login(PlayerEvent.PlayerLoggedInEvent var1) {
                ((EntityPlayerMP)var1.player).field_71135_a.func_147359_a((Packet)new S__PacketSendUUID(var1.player));
            }

            public S__PacketSendUUID() {
            }

            public S__PacketSendUUID(EntityPlayer var1) {
                this.id = var1.func_146103_bH().getId();
            }

            public void func_148837_a(PacketBuffer var1) throws IOException {
                this.id = new UUID(var1.readLong(), var1.readLong());
            }

            public void func_148840_b(PacketBuffer var1) throws IOException {
                var1.writeLong(this.id.getMostSignificantBits());
                var1.writeLong(this.id.getLeastSignificantBits());
            }

            public boolean func_148836_a() {
                return true;
            }

            public void func_148833_a(INetHandler var1) {
                cachedId = this.id;
            }
        }
    }
}

