/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import java.io.File;
import makamys.coretweaks.Config;
import makamys.coretweaks.Persistence;
import makamys.coretweaks.optimization.FastDeobfuscationRemapper;
import makamys.coretweaks.optimization.ForgeFastWildcardTransformers;
import makamys.coretweaks.optimization.JarDiscovererCache;
import makamys.coretweaks.optimization.LibraryTransformationExcluder;
import makamys.coretweaks.optimization.ThreadedTextureLoader;
import makamys.coretweaks.optimization.transformercache.full.CachingTransformer;
import makamys.coretweaks.optimization.transformercache.lite.TransformerCache;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoreTweaks {
    public static final String MODID = "coretweaks";
    public static final String VERSION = "0.3.3.1";
    public static ThreadedTextureLoader textureLoader;
    public static CachingTransformer cachingTransformer;
    public static int boundTexture;
    public static boolean isStitching;
    public static final Logger LOGGER;
    public static final File MY_DIR;
    public static final File OUT_DIR;
    public static final File CACHE_DIR;

    public static void init() {
        CoreTweaks.excludeRepackagedLibraries();
        if (Config.excludeLibraryTransformation.isActive()) {
            LibraryTransformationExcluder.run();
        }
        if (Config.threadedTextureLoader.isActive()) {
            textureLoader = new ThreadedTextureLoader(Config.threadedTextureLoaderThreadCount != 0 ? Config.threadedTextureLoaderThreadCount : Runtime.getRuntime().availableProcessors());
        }
        if (Config.transformerCache.isActive() && Config.transformerCacheMode == Config.TransformerCache.FULL) {
            Persistence.loadIfNotLoadedAlready();
            cachingTransformer = CachingTransformer.register();
            Persistence.lastVersion = VERSION;
            Persistence.save();
        }
        if (Config.jarDiscovererCache.isActive()) {
            JarDiscovererCache.instance = new JarDiscovererCache();
        }
        if (FastDeobfuscationRemapper.isActive()) {
            FastDeobfuscationRemapper.init();
        }
        if (Config.forgeFastWildcardTransformers.isActive()) {
            ForgeFastWildcardTransformers.instance = new ForgeFastWildcardTransformers();
        }
        if (Config.transformerCache.isActive() && Config.transformerCacheMode == Config.TransformerCache.LITE && !Config.lateLiteTransformerCache) {
            TransformerCache.instance.init(false);
        }
    }

    private static void excludeRepackagedLibraries() {
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.");
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.repackage.net.sf.cglib.");
    }

    public static Logger logger() {
        return LogManager.getLogger((String)MODID);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        MY_DIR = new File(Launch.minecraftHome, MODID);
        OUT_DIR = new File(MY_DIR, "out");
        CACHE_DIR = new File(MY_DIR, "cache");
    }
}

