/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import com.google.common.primitives.Bytes;
import cpw.mods.fml.common.asm.transformers.SideTransformer;
import java.util.ArrayList;
import java.util.List;
import makamys.coretweaks.optimization.transformerproxy.ITransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxy;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxyManager;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FluidIdTransformer;

public class ForgeFastWildcardTransformers
implements TransformerProxyManager.ITransformerWrapperProvider {
    public static ForgeFastWildcardTransformers instance;
    public static final String FLUID_ID_TRANSFORMER_PATTERN = "fluidID";
    public static final String SIDE_TRANSFORMER_PATTERN = "cpw/mods/fml/relauncher/SideOnly";

    public ForgeFastWildcardTransformers() {
        TransformerProxyManager.instance.addAdditionListener(this, true);
    }

    @Override
    public ITransformerWrapper wrap(IClassTransformer transformer) {
        if (transformer instanceof FluidIdTransformer) {
            return new PatternConditionalTransformerWrapper(FLUID_ID_TRANSFORMER_PATTERN);
        }
        if (transformer instanceof SideTransformer) {
            return new PatternConditionalTransformerWrapper(SIDE_TRANSFORMER_PATTERN);
        }
        return null;
    }

    public static class PatternConditionalTransformerWrapper
    implements ITransformerWrapper {
        private final List<byte[]> patterns = new ArrayList<byte[]>();

        public PatternConditionalTransformerWrapper(String ... patterns) {
            for (String pattern : patterns) {
                this.patterns.add(pattern.getBytes());
            }
        }

        @Override
        public byte[] wrapTransform(String name, String transformedName, byte[] basicClass, TransformerProxy proxy) {
            if (this.containsAnyPattern(basicClass)) {
                return proxy.invokeNextHandler(name, transformedName, basicClass);
            }
            return basicClass;
        }

        private boolean containsAnyPattern(byte[] array) {
            if (array == null) {
                return false;
            }
            for (byte[] pattern : this.patterns) {
                if (Bytes.indexOf((byte[])array, (byte[])pattern) == -1) continue;
                return true;
            }
            return false;
        }
    }
}

