/*
 * Decompiled with CFR 0.152.
 */
package net.divinerpg.entities.vethea;

import net.divinerpg.entities.base.EntityStats;
import net.divinerpg.entities.vethea.VetheaMob;
import net.divinerpg.libs.Sounds;
import net.divinerpg.utils.items.VetheaItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityLorgaFlight
extends VetheaMob {
    private ChunkCoordinates currentFlightTarget;
    private int flyTimer;
    private int spawnTick;
    public boolean canSpawnMinions;

    public EntityLorgaFlight(World w) {
        this(w, true);
    }

    public EntityLorgaFlight(World var1, boolean canSpawnMinions) {
        super(var1);
        this.canSpawnMinions = canSpawnMinions;
        this.flyTimer = 0;
        this.addAttackingAI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EntityStats.lorgaFlightHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityStats.lorgaFlightSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityStats.lorgaFlightFollowRange);
    }

    @Override
    public int getSpawnLayer() {
        return 3;
    }

    public void func_70069_a(float f) {
    }

    @Override
    protected String func_70639_aQ() {
        return Sounds.lorgaFlight.getPrefixedName();
    }

    @Override
    protected String func_70621_aR() {
        return Sounds.lorgaFlightHurt.getPrefixedName();
    }

    @Override
    protected String func_70673_aS() {
        return this.func_70621_aR();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.spawnTick == 0 && this.canSpawnMinions && !this.field_70170_p.field_72995_K) {
            this.spawnTick = 200;
            EntityLorgaFlight var2 = new EntityLorgaFlight(this.field_70170_p, false);
            var2.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72838_d((Entity)var2);
        } else if (this.spawnTick > 0) {
            --this.spawnTick;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x *= (double)0.6f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_70789_a != null) {
            int var1 = (int)this.field_70789_a.field_70165_t;
            int var2 = (int)this.field_70789_a.field_70163_u;
            int var3 = (int)this.field_70789_a.field_70161_v;
            this.currentFlightTarget = new ChunkCoordinates(var1, var2, var3);
        } else if (this.flyTimer != 0) {
            this.flyTimer = 120;
            this.currentFlightTarget = new ChunkCoordinates((int)(this.field_70165_t + (double)this.field_70146_Z.nextInt(16)) - 8, (int)(this.field_70163_u + (double)this.field_70146_Z.nextInt(32)) - 16, (int)(this.field_70161_v + (double)this.field_70146_Z.nextInt(16)) - 8);
        }
        if (this.currentFlightTarget != null) {
            double var1 = (double)this.currentFlightTarget.field_71574_a - this.field_70165_t;
            double var3 = (double)this.currentFlightTarget.field_71572_b - this.field_70163_u;
            double var5 = (double)this.currentFlightTarget.field_71573_c - this.field_70161_v;
            if (Math.signum(var1) != 0.0 || Math.signum(var3) != 0.0 || Math.signum(var5) != 0.0) {
                this.field_70159_w += (Math.signum(var1) * 0.15 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(var3) * 1.699999988079071 - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(var5) * 0.15 - this.field_70179_y) * (double)0.1f;
                float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
                this.field_70701_bs = 0.5f;
                this.field_70177_z += var8;
            }
            --this.flyTimer;
        }
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74757_a("CanSpawnMinions", this.canSpawnMinions);
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.canSpawnMinions = tag.func_74767_n("CanSpawnMinions");
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_145779_a(VetheaItems.polishedPearls, 1);
    }

    @Override
    public String mobName() {
        return "Lorgaflight";
    }
}

