/*
 * Decompiled with CFR 0.152.
 */
package net.divinerpg.entities.vethea;

import java.util.List;
import net.divinerpg.entities.base.EntityDivineRPGBoss;
import net.divinerpg.entities.base.EntityStats;
import net.divinerpg.entities.vethea.projectile.EntityRaglokBomb;
import net.divinerpg.libs.Sounds;
import net.divinerpg.utils.MessageLocalizer;
import net.divinerpg.utils.Util;
import net.divinerpg.utils.items.VetheaItems;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityRaglok
extends EntityDivineRPGBoss {
    private int ability;
    private final int DEFAULT = 0;
    private final int LIGHTNING = 1;
    private final int BLIND = 2;
    private final int BOMBS = 3;
    private final int SLOW = 4;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private int deathTicks;

    public EntityRaglok(World par1) {
        super(par1);
        this.addAttackingAI();
        this.field_70178_ae = true;
        this.ability = 0;
        this.func_70105_a(1.5f, 4.0f);
    }

    protected void func_70619_bc() {
        this.manageAbilities();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EntityStats.raglokHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(EntityStats.raglokDamage);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityStats.raglokSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityStats.raglokFollowRange);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.loaded && !this.field_70170_p.field_72995_K) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(30.0, 30.0, 30.0));
            for (EntityPlayer p : players) {
                p.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.dare")));
                this.field_70170_p.func_72956_a((Entity)p, Sounds.raglokAwaken.getPrefixedName(), 1.0f, 1.0f);
            }
            this.loaded = true;
        }
    }

    public void manageAbilities() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 64.0);
        if (this.abilityCooldown == 0 || this.ability == 0) {
            this.abilityCooldown = 400;
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
                    break;
                }
                case 1: {
                    this.ability = 2;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
                case 3: {
                    this.ability = 4;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2 && player != null) {
            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 25, 0, true));
        }
        if (this.ability == 4 && player != null) {
            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 1, true));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0 && player != null) {
                this.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(this.field_70170_p, this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ));
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 40 != 0 && this.abilityCooldown % 20 == 0 && player != null) {
                this.prevPlayerX = player.field_70165_t;
                this.prevPlayerY = player.field_70163_u;
                this.prevPlayerZ = player.field_70161_v;
            }
            if (this.rangedAttackCounter == 10) {
                this.ability = 0;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 30 == 0 && player != null) {
                for (int i = 0; i < 4; ++i) {
                    EntityRaglokBomb var2 = new EntityRaglokBomb(this.field_70170_p);
                    var2.func_70107_b(player.field_70165_t, player.field_70163_u + 5.0, player.field_70161_v);
                    var2.field_70159_w = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0;
                    var2.field_70181_x = -0.14;
                    var2.field_70179_y = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0;
                    this.field_70170_p.func_72838_d((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 12) {
                this.ability = 0;
            }
        }
    }

    private void message() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
        block6: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)list.get(var1);
            switch (this.ability) {
                case 1: {
                    this.func_85030_a(Sounds.raglokGuardian.getPrefixedName(), 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.think")));
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.great")));
                    continue block6;
                }
                case 2: {
                    this.func_85030_a(Sounds.raglokDark.getPrefixedName(), 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.future")));
                    continue block6;
                }
                case 3: {
                    this.func_85030_a(Sounds.raglokRain.getPrefixedName(), 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.rain")));
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.kill")));
                    continue block6;
                }
                case 4: {
                    this.func_85030_a(Sounds.raglokNothing.getPrefixedName(), 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.compare")));
                    continue block6;
                }
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Integer(100));
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    @Override
    protected String func_70673_aS() {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(30.0, 30.0, 30.0));
            for (EntityPlayer p : players) {
                p.func_145747_a(Util.getChatComponent(MessageLocalizer.normal("message.raglok.avenge")));
            }
        }
        if ((player = this.field_70170_p.func_72856_b((Entity)this, 64.0)) != null) {
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v));
            }
        }
        return Sounds.raglokAvenge.getPrefixedName();
    }

    public boolean func_70652_k(Entity par1Entity) {
        int var2 = (int)EntityStats.raglokDamage;
        int var3 = 0;
        boolean var4 = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)var2);
        if (var4) {
            int var5;
            if (this.ability == 4) {
                var3 = 5;
            }
            if (var3 > 0) {
                par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)var3 * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)var3 * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((var5 = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                par1Entity.func_70015_d(var5 * 4);
            }
        }
        return var4;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_145779_a(VetheaItems.heliosisLump, 25);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float var1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float var2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float var3 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int var5;
                for (int var4 = 1000; var4 > 0; var4 -= var5) {
                    var5 = EntityXPOrb.func_70527_a((int)var4);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
                }
            }
            if (this.deathTicks == 1 && this.field_70170_p.func_72856_b((Entity)this, 64.0) != null) {
                this.field_70170_p.func_72856_b((Entity)this, 64.0).func_70097_a(DamageSource.field_76376_m, 16.0f);
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int var5;
            for (int var4 = 2000; var4 > 0; var4 -= var5) {
                var5 = EntityXPOrb.func_70527_a((int)var4);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
            }
            this.func_70106_y();
        }
    }

    @Override
    public String mobName() {
        return "Raglok";
    }

    @Override
    public String name() {
        return "Raglok";
    }

    @Override
    public IChatComponent chat() {
        return null;
    }
}

