/*
 * Decompiled with CFR 0.152.
 */
package net.divinerpg.items.base;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.divinerpg.entities.base.EntityDivineArrow;
import net.divinerpg.utils.LangRegistry;
import net.divinerpg.utils.TooltipLocalizer;
import net.divinerpg.utils.tabs.DivineRPGTabs;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemModBow
extends ItemBow {
    public static List<Item> bowList = new ArrayList<Item>();
    public static final int DEFAULT_MAX_USE_DURATION = 72000;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] IIconArray;
    protected String name;
    protected String textureName;
    protected final String[] texture;
    protected int damageMin;
    protected int damageMax;
    protected int maxUseDuration;
    protected boolean unbreakable;
    protected Item arrow;
    protected boolean needArrow = true;
    protected String arrowTex;
    private String sound = "random.bow";
    private boolean vethean = false;

    public ItemModBow(String name, int uses, int damageMin, int damageMax, Item arrow) {
        this(name, uses, damageMin, damageMax, 72000, arrow);
    }

    public ItemModBow(String name, int uses, int damageMin, int damageMax, String arrowTex) {
        this(name, uses, damageMin, damageMax, 72000, null);
        this.arrowTex = arrowTex;
    }

    public ItemModBow(String name, int uses, int damageMin, int damageMax, Item arrow, String arrowTex) {
        this(name, uses, damageMin, damageMax, 72000, arrow);
        this.arrowTex = arrowTex;
    }

    public ItemModBow(String name, int uses, int damageMin, int damageMax, int maxUseDuraction) {
        this(name, uses, damageMin, damageMax, maxUseDuraction, null);
    }

    public ItemModBow(String name, int uses, int damageMin, int damageMax, int maxUseDuraction, Item arrow, String arrowTex) {
        this(name, uses, damageMin, damageMax, maxUseDuraction, arrow);
        this.arrowTex = arrowTex;
    }

    public ItemModBow(String name, int uses, int damageMin, int damageMax, int maxUseDuraction, Item arrow) {
        this.func_77656_e(uses);
        this.name = name;
        this.textureName = "divinerpg:" + name;
        if (arrow == null) {
            this.needArrow = false;
        } else {
            this.arrow = arrow;
        }
        this.damageMin = damageMin;
        this.damageMax = damageMax;
        this.maxUseDuration = maxUseDuraction;
        this.unbreakable = true;
        this.field_77777_bU = 1;
        this.func_77637_a(DivineRPGTabs.ranged);
        this.texture = new String[]{this.textureName + "_0", this.textureName + "_1", this.textureName + "_2", this.textureName + "_3"};
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
        LangRegistry.addItem((Item)this);
        bowList.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(this.texture[0]);
        this.IIconArray = new IIcon[this.texture.length];
        for (int i = 0; i < this.texture.length; ++i) {
            this.IIconArray[i] = icon.func_94245_a(this.texture[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int icon) {
        return this.IIconArray[icon];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (player.func_71011_bu() == null) {
            return this.field_77791_bV;
        }
        int pulling = stack.func_77988_m() - useRemaining;
        if (pulling >= 18 / (72000 / this.func_77626_a(stack))) {
            return this.IIconArray[3];
        }
        if (pulling > 13 / (72000 / this.func_77626_a(stack))) {
            return this.IIconArray[2];
        }
        if (pulling > 0) {
            return this.IIconArray[1];
        }
        return this.IIconArray[0];
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemUseCount) {
        boolean infiniteAmmo;
        int maxItemUse = this.func_77626_a(stack) - itemUseCount;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, maxItemUse);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        maxItemUse = event.charge;
        boolean bl = infiniteAmmo = !this.needArrow || player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (infiniteAmmo || player.field_71071_by.func_146028_b(this.arrow)) {
            int punchLevel;
            int powerLevel;
            float timeRatio = 72000 / this.func_77626_a(stack);
            float scaledItemUse = (float)maxItemUse / 20.0f * timeRatio;
            if ((double)(scaledItemUse = (scaledItemUse * scaledItemUse + scaledItemUse * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (scaledItemUse > 1.0f) {
                scaledItemUse = 1.0f;
            }
            EntityDivineArrow entityarrow = this.arrow != null && this.arrowTex == null ? new EntityDivineArrow(world, (EntityLivingBase)player, scaledItemUse * 2.0f, this.damageMin, this.damageMax, this.arrow.func_77658_a().replace("item.", "")) : new EntityDivineArrow(world, (EntityLivingBase)player, scaledItemUse * 2.0f, this.damageMin, this.damageMax, this.arrowTex);
            entityarrow.setAmmoItem(this.arrow);
            if (scaledItemUse == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((powerLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(punchLevel);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            if (!this.unbreakable) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_72956_a((Entity)player, this.sound, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + scaledItemUse * 0.5f);
            if (infiniteAmmo) {
                entityarrow.field_70251_a = 2;
            } else {
                player.field_71071_by.func_146026_a(this.arrow);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(TooltipLocalizer.bowDam(this.damageMin + "-" + this.damageMax));
        double speed = 72000.0 / (double)this.func_77626_a(stack);
        if (speed > 1.0) {
            list.add(speed + " Times Faster");
        }
        if (speed < 1.0) {
            list.add(1.0 / speed + " Times Slower");
        }
        list.add(!this.unbreakable ? TooltipLocalizer.usesRemaining(stack.func_77958_k() - stack.func_77960_j()) : TooltipLocalizer.infiniteUses());
        if (this.arrowTex == "bluefireArrow" || this.arrowTex == "snowstormArrow") {
            list.add(TooltipLocalizer.explosiveShots());
        }
        list.add(this.arrow == null ? TooltipLocalizer.infiniteAmmo() : TooltipLocalizer.ammo(this.arrow));
        if (this.vethean) {
            list.add(TooltipLocalizer.vethean());
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean infiniteAmmo;
        ArrowNockEvent nockEvent = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)nockEvent);
        if (nockEvent.isCanceled()) {
            return nockEvent.result;
        }
        boolean bl = infiniteAmmo = !this.needArrow || player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0 && player.field_71071_by.func_146028_b(this.arrow);
        if (infiniteAmmo || player.field_71071_by.func_146028_b(this.arrow)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public ItemModBow setSound(String newSound) {
        this.sound = newSound;
        return this;
    }

    public ItemModBow setVethean() {
        this.func_77637_a(DivineRPGTabs.vethea);
        this.vethean = true;
        return this;
    }
}

