/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Core;

import DummyCore.Core.DCMod;
import DummyCore.CreativeTabs.CreativePageBlocks;
import DummyCore.CreativeTabs.CreativePageItems;
import DummyCore.Utils.IDummyConfig;
import DummyCore.Utils.LoadingUtils;
import DummyCore.Utils.Notifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;

public class Core {
    public static final ArrayList<DCMod> registeredMods = new ArrayList();
    public static File mcDir;

    public static boolean isModRegistered(Class<?> mod) {
        for (DCMod dcm : registeredMods) {
            if (!dcm.modClass.equals(mod)) continue;
            return true;
        }
        return false;
    }

    public static DCMod getModFromClass(Class<?> c) {
        for (DCMod dcm : registeredMods) {
            if (!dcm.modClass.equals(c)) continue;
            return dcm;
        }
        return null;
    }

    private static void registerMod(Class<?> c, String name, boolean addCreativeTabs) {
        if (!Core.isModRegistered(c)) {
            DCMod mod = new DCMod(c, name);
            if (addCreativeTabs) {
                mod.blocks = new CreativePageBlocks(name);
                mod.items = new CreativePageItems(name);
            }
            registeredMods.add(mod);
        } else {
            Notifier.notifyError(name + "[classPath:" + c + "]Already has a DummyCore mod associated with it(is already registered), ignoring");
        }
    }

    private static void registerConfigurationFileForMod(Class<?> c, String path) {
        try {
            if (!Core.isModRegistered(c)) {
                LoadingUtils.makeACrash("[DummyCore]Catched an attempt to register configuration file for not registered mod, this should not be possible and many things will go wrong as a result!", new IllegalStateException(c + " Is not a valid DCMod!"), false);
            } else {
                DCMod mod = Core.getModFromClass(c);
                File file = new File(path, mod.ufName + ".cfg");
                if (file.isDirectory()) {
                    file.delete();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                Configuration cfg = new Configuration(file);
                cfg.save();
                mod.injectFMLConfig(cfg);
                Notifier.notifySimple("Configuration File for mod " + mod + " was successfully created with path " + path + mod.ufName + ".cfg");
            }
        }
        catch (IOException e) {
            DCMod mod = Core.getModFromClass(c);
            LoadingUtils.makeACrash("[DummyCore]Could not create a config file for mod " + mod + " - check your file system!", e, true);
        }
    }

    public static void registerModAbsolute(Class<?> c, String modname, String configPath, IDummyConfig config) {
        Core.registerModAbsolute(c, modname, configPath, config, true);
    }

    public static void registerModAbsolute(Class<?> c, String modname, String configPath, IDummyConfig config, boolean addCreativeTabs) {
        Core.registerMod(c, modname, addCreativeTabs);
        Core.registerConfigurationFileForMod(c, configPath);
        Core.registerConfigurationHandler(config, c);
        Core.loadConfigForMod(c);
    }

    public static Configuration getConfigFileForMod(Class<?> c) {
        if (!Core.isModRegistered(c)) {
            Notifier.notifyError("Catched an attempt to get configuration for a not registered mod, things are about go wery wrong! Offendor: " + c);
            return null;
        }
        return Core.getModFromClass(c).fmlCfg;
    }

    private static void registerConfigurationHandler(IDummyConfig config, Class<?> c) {
        if (!Core.isModRegistered(c)) {
            LoadingUtils.makeACrash("[DummyCore]Catched an attempt to register IDummyConfig for not registered mod, this should not be possible and many things will go wrong as a result!", new IllegalStateException(c + " Is not a valid DCMod!"), false);
        } else {
            DCMod mod = Core.getModFromClass(c);
            mod.injectConfig(config);
            Notifier.notifySimple("IDummyConfing for mod " + mod + " was successfully created");
        }
    }

    public static void loadConfigForMod(Class<?> c) {
        if (!Core.isModRegistered(c)) {
            LoadingUtils.makeACrash("[DummyCore]Catched an attempt to load IDummyConfig for not registered mod, this should not be possible and many things will go wrong as a result!", new IllegalStateException(c + " Is not a valid DCMod!"), false);
        } else {
            DCMod mod = Core.getModFromClass(c);
            mod.fmlCfg.load();
            mod.cfg.load(mod.fmlCfg);
            mod.fmlCfg.save();
        }
    }

    public static CreativeTabs getItemTabForMod(Class<?> c) {
        if (!Core.isModRegistered(c)) {
            Notifier.notifyError("Catched an attempt to get CreativeTabs for a not registered mod, things are about go wery wrong! Offendor: " + c);
            return null;
        }
        return Core.getModFromClass(c).items;
    }

    public static CreativeTabs getBlockTabForMod(Class<?> c) {
        if (!Core.isModRegistered(c)) {
            Notifier.notifyError("Catched an attempt to get CreativeTabs for a not registered mod, things are about go wery wrong! Offendor: " + c);
            return null;
        }
        return Core.getModFromClass(c).blocks;
    }
}

