/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GIFImage {
    public int frames;
    public BufferedImage[] images;
    public int[] imagesGLIDs;
    public static final int PIXEL_FORMAT_RGBA = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GIFImage(ResourceLocation texture) {
        InputStream is = null;
        try {
            int i;
            is = Minecraft.func_71410_x().field_110450_ap.func_110590_a(texture);
            ImageInputStream stream = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new IOException("No suitable reader found for image" + texture);
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            this.frames = reader.getNumImages(true);
            BufferedImage[] images = new BufferedImage[this.frames];
            this.imagesGLIDs = new int[this.frames];
            for (i = 0; i < this.frames; ++i) {
                images[i] = reader.read(i);
            }
            reader.dispose();
            for (i = 0; i < this.frames; ++i) {
                this.imagesGLIDs[i] = this.loadTexture(images[i]);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public void drawOnScreen(int frame, double minU, double minV, double maxU, double maxV, int sizeX, int sizeY) {
        GL11.glBindTexture((int)3553, (int)this.imagesGLIDs[frame]);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)minU, (double)minV);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2d((double)maxU, (double)minV);
        GL11.glVertex2f((float)sizeX, (float)0.0f);
        GL11.glTexCoord2d((double)maxU, (double)maxV);
        GL11.glVertex2f((float)sizeX, (float)sizeY);
        GL11.glTexCoord2d((double)minU, (double)maxV);
        GL11.glVertex2f((float)0.0f, (float)sizeY);
        GL11.glEnd();
    }

    private int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }
}

