/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.Pair;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class StructureApi {
    public static NBTTagCompound createStructureTagIgnoreMetadata(World w, AxisAlignedBB aabb, boolean whitelist, Block ... blocks) {
        NBTTagCompound tag = new NBTTagCompound();
        if (aabb.field_72340_a > aabb.field_72336_d) {
            double mX = aabb.field_72340_a;
            aabb.field_72340_a = aabb.field_72336_d;
            aabb.field_72336_d = mX;
        }
        if (aabb.field_72338_b > aabb.field_72337_e) {
            double mY = aabb.field_72338_b;
            aabb.field_72338_b = aabb.field_72337_e;
            aabb.field_72337_e = mY;
        }
        if (aabb.field_72339_c > aabb.field_72334_f) {
            double mZ = aabb.field_72339_c;
            aabb.field_72339_c = aabb.field_72334_f;
            aabb.field_72334_f = mZ;
        }
        int dx = (int)aabb.field_72340_a;
        while ((double)dx <= aabb.field_72336_d) {
            int dy = (int)aabb.field_72338_b;
            while ((double)dy <= aabb.field_72337_e) {
                int dz = (int)aabb.field_72339_c;
                while ((double)dz <= aabb.field_72334_f) {
                    Block b = w.func_147439_a(dx, dy, dz);
                    if (b != null) {
                        String coords;
                        int i;
                        boolean include = false;
                        if (whitelist) {
                            for (i = 0; i < blocks.length; ++i) {
                                if (!blocks[i].equals(b)) continue;
                                include = true;
                                break;
                            }
                        } else {
                            include = true;
                            for (i = 0; i < blocks.length; ++i) {
                                if (!blocks[i].equals(b)) continue;
                                include = false;
                                break;
                            }
                        }
                        if (include && !tag.func_74764_b(coords = String.valueOf((double)dx - aabb.field_72340_a - (aabb.field_72336_d - aabb.field_72340_a) / 2.0) + "|" + String.valueOf((double)dy - aabb.field_72338_b) + "|" + String.valueOf((double)dz - aabb.field_72339_c - (aabb.field_72334_f - aabb.field_72339_c) / 2.0))) {
                            tag.func_74778_a(coords, GameRegistry.findUniqueIdentifierFor((Block)b).toString());
                        }
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        return tag;
    }

    public static NBTTagCompound createStructureTag(World w, AxisAlignedBB aabb, boolean whitelist, Block ... blocks) {
        NBTTagCompound tag = new NBTTagCompound();
        if (aabb.field_72340_a > aabb.field_72336_d) {
            double mX = aabb.field_72340_a;
            aabb.field_72340_a = aabb.field_72336_d;
            aabb.field_72336_d = mX;
        }
        if (aabb.field_72338_b > aabb.field_72337_e) {
            double mY = aabb.field_72338_b;
            aabb.field_72338_b = aabb.field_72337_e;
            aabb.field_72337_e = mY;
        }
        if (aabb.field_72339_c > aabb.field_72334_f) {
            double mZ = aabb.field_72339_c;
            aabb.field_72339_c = aabb.field_72334_f;
            aabb.field_72334_f = mZ;
        }
        int dx = (int)aabb.field_72340_a;
        while ((double)dx <= aabb.field_72336_d) {
            int dy = (int)aabb.field_72338_b;
            while ((double)dy <= aabb.field_72337_e) {
                int dz = (int)aabb.field_72339_c;
                while ((double)dz <= aabb.field_72334_f) {
                    Block b = w.func_147439_a(dx, dy, dz);
                    if (b != null) {
                        String coords;
                        int i;
                        boolean include = false;
                        if (whitelist) {
                            for (i = 0; i < blocks.length; ++i) {
                                if (!blocks[i].equals(b)) continue;
                                include = true;
                                break;
                            }
                        } else {
                            include = true;
                            for (i = 0; i < blocks.length; ++i) {
                                if (!blocks[i].equals(b)) continue;
                                include = false;
                                break;
                            }
                        }
                        if (include && !tag.func_74764_b(coords = String.valueOf((double)dx - aabb.field_72340_a - (aabb.field_72336_d - aabb.field_72340_a) / 2.0) + "|" + String.valueOf((double)dy - aabb.field_72338_b) + "|" + String.valueOf((double)dz - aabb.field_72339_c - (aabb.field_72334_f - aabb.field_72339_c) / 2.0))) {
                            tag.func_74778_a(coords, GameRegistry.findUniqueIdentifierFor((Block)b).toString() + "|" + w.func_72805_g(dx, dy, dz));
                        }
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        return tag;
    }

    public static void nbtStructureIntoWorld(World w, int x, int y, int z, NBTTagCompound structureTag) {
        Set keySet = structureTag.func_150296_c();
        ArrayList keys = new ArrayList();
        ArrayList<Pair<Coord3D, Pair<Block, Integer>>> structure = new ArrayList<Pair<Coord3D, Pair<Block, Integer>>>();
        Iterator $i = keySet.iterator();
        while ($i.hasNext()) {
            keys.add($i.next());
        }
        for (String string : keys) {
            int dx = (int)Double.parseDouble(string.substring(0, string.indexOf(124)));
            int dy = (int)Double.parseDouble(string.substring(string.indexOf(124) + 1, string.lastIndexOf(124)));
            int dz = (int)Double.parseDouble(string.substring(string.lastIndexOf(124) + 1));
            Coord3D blockCoord = new Coord3D(dx, dy, dz);
            String st = structureTag.func_74779_i(string);
            String bid = st.indexOf(124) != -1 ? st.substring(0, st.indexOf(124)) : st;
            Block b = GameRegistry.findBlock((String)bid.substring(0, bid.indexOf(58)), (String)bid.substring(bid.indexOf(58) + 1));
            int meta = st.indexOf(124) != -1 ? Integer.parseInt(st.substring(st.indexOf(124) + 1)) : 0;
            Pair<Block, Integer> blockAndMeta = new Pair<Block, Integer>(b, meta);
            structure.add(new Pair<Coord3D, Pair<Block, Integer>>(blockCoord, blockAndMeta));
        }
        keys.clear();
        keys = null;
        for (Pair pair : structure) {
            Coord3D c = (Coord3D)pair.getFirst();
            int dx = (int)(c.x + (float)x);
            int dy = (int)(c.y + (float)y);
            int dz = (int)(c.z + (float)z);
            Pair pa = (Pair)pair.getSecond();
            w.func_147465_d(dx, dy, dz, (Block)pa.getFirst(), ((Integer)pa.getSecond()).intValue(), 2);
        }
        structure.clear();
        structure = null;
    }

    public static boolean areNBTTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1.func_82582_d() || tag2.func_82582_d()) {
            return false;
        }
        Set keys = tag1.func_150296_c();
        for (String key : keys) {
            NBTBase base1 = tag1.func_74781_a(key);
            if (!tag2.func_74764_b(key)) {
                return false;
            }
            NBTBase base2 = tag2.func_74781_a(key);
            if (StructureApi.compareTagsPrimitive(base1, base2)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareTagsPrimitive(NBTBase base1, NBTBase base2) {
        byte id2;
        byte id1 = base1.func_74732_a();
        if (id1 != (id2 = base2.func_74732_a())) {
            return false;
        }
        switch (id1) {
            case 0: {
                return true;
            }
            case 1: {
                NBTTagByte byte1 = (NBTTagByte)base1;
                NBTTagByte byte2 = (NBTTagByte)base2;
                return byte1.func_150290_f() == byte2.func_150290_f();
            }
            case 2: {
                NBTTagShort short1 = (NBTTagShort)base1;
                NBTTagShort short2 = (NBTTagShort)base2;
                return short1.func_150289_e() == short2.func_150289_e();
            }
            case 3: {
                NBTTagInt int1 = (NBTTagInt)base1;
                NBTTagInt int2 = (NBTTagInt)base2;
                return int1.func_150287_d() == int2.func_150287_d();
            }
            case 4: {
                NBTTagLong long1 = (NBTTagLong)base1;
                NBTTagLong long2 = (NBTTagLong)base2;
                return long1.func_150291_c() == long2.func_150291_c();
            }
            case 5: {
                NBTTagFloat float1 = (NBTTagFloat)base1;
                NBTTagFloat float2 = (NBTTagFloat)base2;
                return float1.func_150288_h() == float2.func_150288_h();
            }
            case 6: {
                NBTTagDouble double1 = (NBTTagDouble)base1;
                NBTTagDouble double2 = (NBTTagDouble)base2;
                return double1.func_150286_g() == double2.func_150286_g();
            }
            case 7: {
                NBTTagByteArray byteArray1 = (NBTTagByteArray)base1;
                NBTTagByteArray byteArray2 = (NBTTagByteArray)base2;
                return byteArray1.equals((Object)byteArray2);
            }
            case 8: {
                NBTTagString string1 = (NBTTagString)base1;
                NBTTagString string2 = (NBTTagString)base2;
                return string1.equals((Object)string2);
            }
            case 9: {
                NBTTagList list1 = (NBTTagList)base1;
                NBTTagList list2 = (NBTTagList)base2;
                return list1.equals((Object)list2);
            }
            case 10: {
                NBTTagCompound tag1 = (NBTTagCompound)base1;
                NBTTagCompound tag2 = (NBTTagCompound)base2;
                return tag1.equals((Object)tag2);
            }
            case 11: {
                NBTTagIntArray intArray1 = (NBTTagIntArray)base1;
                NBTTagIntArray intArray2 = (NBTTagIntArray)base2;
                return intArray1.equals((Object)intArray2);
            }
        }
        return true;
    }
}

