/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.block.BloodChest;
import evilcraft.client.render.item.RenderItemBloodChest;
import evilcraft.client.render.tileentity.RenderTileEntityBloodChest;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.extendedconfig.BlockContainerConfig;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.item.ItemBlockNBT;
import evilcraft.proxy.ClientProxy;
import evilcraft.tileentity.TileBloodChest;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;

public class BloodChestConfig
extends BlockContainerConfig {
    public static BloodChestConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If the Blood Chest should add random bad enchants with a small chance to repairing items.", isCommandable=true)
    public static boolean addRandomBadEnchants;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The amount Blood mB required for repairing one damage value.", isCommandable=true)
    public static int mBPerDamage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The amount of ticks required for repairing one damage value.", isCommandable=true)
    public static int ticksPerDamage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If the Blood Chest should be able to repair tools from Tinkers' Construct", isCommandable=true)
    public static boolean repairTConstructTools;

    public BloodChestConfig() {
        super(true, "bloodChest", (String)null, (Class<? extends Block>)BloodChest.class);
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockNBT.class;
    }

    @Override
    public void onRegistered() {
        if (MinecraftHelpers.isClientSide()) {
            this.registerClientSide();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerClientSide() {
        ModelChest model = new ModelChest();
        ResourceLocation texture = new ResourceLocation("evilcraft", "textures/models/bloodChest.png");
        ClientProxy.TILE_ENTITY_RENDERERS.put(TileBloodChest.class, new RenderTileEntityBloodChest((ModelBase)model, texture));
        ClientProxy.ITEM_RENDERERS.put(Item.func_150898_a((Block)BloodChest.getInstance()), new RenderItemBloodChest((ModelBase)model, texture));
    }

    static {
        addRandomBadEnchants = true;
        mBPerDamage = 5;
        ticksPerDamage = 2;
        repairTConstructTools = true;
    }
}

