/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.client.particle.EntityBloodSplashFX;
import evilcraft.core.client.render.block.AlternatingBlockIconComponent;
import evilcraft.core.config.configurable.ConfigurableBlockWithInnerBlocksExtended;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.core.tileentity.InnerBlocksTileEntity;
import evilcraft.tileentity.TileBloodStainedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BloodStainedBlock
extends ConfigurableBlockWithInnerBlocksExtended {
    private static BloodStainedBlock _instance = null;
    private AlternatingBlockIconComponent alternatingBlockIconComponent = new AlternatingBlockIconComponent(this.getAlternateIconsAmount());

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodStainedBlock(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodStainedBlock getInstance() {
        return _instance;
    }

    private BloodStainedBlock(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151583_m, (Class<? extends InnerBlocksTileEntity>)TileBloodStainedBlock.class);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149767_g);
    }

    public int getAlternateIconsAmount() {
        return 3;
    }

    @Override
    public int getRenderPasses() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.alternatingBlockIconComponent.registerIcons(this.func_149641_N(), iconRegister);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        try {
            return this.getIcon(side, world.func_72805_g(x, y, z), this.pass, this.alternatingBlockIconComponent.getAlternateIcon(world, x, y, z, side), this.getTile(world, x, y, z).getInnerBlock());
        }
        catch (ConfigurableBlockWithInnerBlocksExtended.InvalidInnerBlocksTileException e) {
            return super.func_149673_e(world, x, y, z, side);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta, int renderPass, IIcon defaultIcon, Block baseBlock) throws ConfigurableBlockWithInnerBlocksExtended.InvalidInnerBlocksTileException {
        if (baseBlock == null) {
            throw new ConfigurableBlockWithInnerBlocksExtended.InvalidInnerBlocksTileException();
        }
        if (renderPass < 0) {
            return RenderHelpers.EMPTYICON;
        }
        if (renderPass == 1) {
            if (side != ForgeDirection.UP.ordinal()) {
                return RenderHelpers.EMPTYICON;
            }
            return defaultIcon;
        }
        return baseBlock.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        BloodStainedBlock.splash(par1World, par2, par3, par4);
        super.func_149699_a(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149724_b(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        BloodStainedBlock.splash(par1World, par2, par3, par4);
        super.func_149724_b(par1World, par2, par3, par4, par5Entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static void splash(World world, int x, int y, int z) {
        if (MinecraftHelpers.isClientSide()) {
            EntityBloodSplashFX.spawnParticles(world, x, y + 1, z, 1, 1 + world.field_73012_v.nextInt(3));
        }
    }

    public void func_149639_l(World world, int x, int y, int z) {
        this.unwrapInnerBlock(world, x, y, z);
    }

    public void stainBlock(World world, ILocation location, int amount) {
        if (LocationHelpers.getBlock(world, location) != this) {
            this.setInnerBlock(world, location);
        }
        TileBloodStainedBlock tile = (TileBloodStainedBlock)LocationHelpers.getTile((IBlockAccess)world, location);
        tile.addAmount(amount);
    }

    public UnstainResult unstainBlock(World world, ILocation location, int amount) {
        UnstainResult result = new UnstainResult();
        if (LocationHelpers.getBlock(world, location) == this) {
            TileBloodStainedBlock tile = (TileBloodStainedBlock)LocationHelpers.getTile((IBlockAccess)world, location);
            int foundAmount = tile.getAmount();
            result.amount = Math.min(amount, foundAmount);
            tile.addAmount(-result.amount);
            if (amount >= foundAmount) {
                result.block = this.unwrapInnerBlock(world, location);
            }
        }
        return result;
    }

    protected boolean isBlacklisted(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        for (String blacklisted : BloodStainedBlockConfig.blockBlacklist) {
            if (!blacklisted.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSetInnerBlock(Block block, IBlockAccess world, int x, int y, int z) {
        return super.canSetInnerBlock(block, world, x, y, z) && !this.isBlacklisted(block);
    }

    public static class UnstainResult {
        public int amount = 0;
        public Block block = null;
    }
}

