/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.IInformationProvider;
import evilcraft.core.block.IBlockRarityProvider;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import evilcraft.core.world.FakeWorld;
import evilcraft.entity.monster.VengeanceSpirit;
import evilcraft.tileentity.TileBoxOfEternalClosure;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BoxOfEternalClosure
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockRarityProvider {
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    private static BoxOfEternalClosure _instance = null;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BoxOfEternalClosure(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BoxOfEternalClosure getInstance() {
        return _instance;
    }

    private BoxOfEternalClosure(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileBoxOfEternalClosure.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149780_i);
        this.setRotatable(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150477_bB.func_149691_a(0, 0);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        EvilCraftTileEntity tile = (EvilCraftTileEntity)world.func_147438_o(x, y, z);
        if (tile.getRotation() == ForgeDirection.EAST || tile.getRotation() == ForgeDirection.WEST) {
            this.func_149676_a(0.2f, 0.0f, 0.0f, 0.8f, 0.43f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.2f, 1.0f, 0.43f, 0.8f);
        }
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getSpiritID(ItemStack itemStack) {
        String innerEntity;
        NBTTagCompound spiritTag;
        if (this.hasPlayer(itemStack)) {
            return -1;
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && (spiritTag = tag.func_74775_l("spiritTag")) != null && (innerEntity = spiritTag.func_74779_i("innerEntity")) != null && !innerEntity.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(innerEntity);
                if (!VengeanceSpirit.canSustainClass(clazz)) {
                    return -1;
                }
                Integer ret = ObfuscationHelpers.getClassToID().get(clazz);
                if (ret == null) {
                    return -1;
                }
                return ret;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public String getSpiritName(ItemStack itemStack) {
        NBTTagCompound spiritTag;
        if (this.hasPlayer(itemStack)) {
            return "Zombie";
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && (spiritTag = tag.func_74775_l("spiritTag")) != null && !spiritTag.func_82582_d()) {
            String innerEntity = spiritTag.func_74779_i("innerEntity");
            if (innerEntity != null && !innerEntity.isEmpty()) {
                try {
                    Class<?> clazz = Class.forName(innerEntity);
                    if (!VengeanceSpirit.canSustainClass(clazz)) {
                        return null;
                    }
                    return (String)EntityList.field_75626_c.get(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                return "vengeanceSpirit";
            }
        }
        return null;
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpirit spirit = new VengeanceSpirit(FakeWorld.getInstance());
        spirit.setGlobalVengeance(true);
        spirit.setIsSwarm(true);
        spirit.func_70109_d(spiritTag);
        String entityId = EntityList.func_75621_b((Entity)spirit);
        spiritTag.func_74778_a("id", entityId);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpirit spirit = new VengeanceSpirit(FakeWorld.getInstance());
        spirit.setPlayerId(playerId.toString());
        spirit.setPlayerName(FORGOTTEN_PLAYER);
        tag.func_74778_a("playerId", spirit.getPlayerId());
        tag.func_74778_a("playerName", spirit.getPlayerName());
        spirit.setGlobalVengeance(true);
        spirit.func_70109_d(spiritTag);
        String entityId = EntityList.func_75621_b((Entity)spirit);
        spiritTag.func_74778_a("id", entityId);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public String getPlayerName(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerName", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerName");
        }
        return "";
    }

    public String getPlayerId(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerId", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerId");
        }
        return "";
    }

    public boolean hasPlayer(ItemStack itemStack) {
        return !this.getPlayerId(itemStack).isEmpty();
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        String content = EnumChatFormatting.ITALIC + L10NHelpers.localize("general.info.empty");
        if (this.hasPlayer(itemStack)) {
            content = this.getPlayerName(itemStack);
        } else {
            String id = this.getSpiritName(itemStack);
            if (id != null) {
                content = L10NHelpers.getLocalizedEntityName(id);
            }
        }
        return EnumChatFormatting.BOLD + L10NHelpers.localize(this.func_149739_a() + ".info.content", EnumChatFormatting.RESET + content);
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileBoxOfEternalClosure tile;
        if (world.func_147438_o(x, y, z) != null && (tile = (TileBoxOfEternalClosure)world.func_147438_o(x, y, z)).getSpiritInstance() != null) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.chestopen", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!world.field_72995_K) {
                tile.releaseSpirit();
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityplayer, par6, par7, par8, par9);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileBoxOfEternalClosure tile;
        if (world.func_147438_o(x, y, z) != null && (tile = (TileBoxOfEternalClosure)world.func_147438_o(x, y, z)).getLidAngle() > 0.0f) {
            return 6;
        }
        return super.getLightValue(world, x, y, z);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item));
        ItemStack swarmStack = new ItemStack(item);
        BoxOfEternalClosure.setVengeanceSwarmContent(swarmStack);
        list.add(swarmStack);
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack) {
        return this.hasPlayer(itemStack) ? EnumRarity.rare : EnumRarity.uncommon;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileBoxOfEternalClosure tile;
        if (world.func_147438_o(x, y, z) != null && (tile = (TileBoxOfEternalClosure)world.func_147438_o(x, y, z)).getSpiritInstance() != null) {
            return 15;
        }
        return super.func_149736_g(world, x, y, z, side);
    }
}

