/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import evilcraft.Configs;
import evilcraft.block.BoxOfEternalClosure;
import evilcraft.client.render.item.RenderItemBoxOfEternalClosure;
import evilcraft.client.render.model.ModelBoxOfEternalClosure;
import evilcraft.client.render.tileentity.RenderTileEntityBoxOfEternalClosure;
import evilcraft.core.config.extendedconfig.BlockContainerConfig;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.item.ItemBlockNBT;
import evilcraft.entity.monster.VengeanceSpiritConfig;
import evilcraft.proxy.ClientProxy;
import evilcraft.tileentity.TileBoxOfEternalClosure;
import evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class BoxOfEternalClosureConfig
extends BlockContainerConfig {
    public static BoxOfEternalClosureConfig _instance;

    public BoxOfEternalClosureConfig() {
        super(true, "boxOfEternalClosure", (String)null, (Class<? extends Block>)BoxOfEternalClosure.class);
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockNBT.class;
    }

    @Override
    public void onRegistered() {
        if (MinecraftHelpers.isClientSide()) {
            ModelBoxOfEternalClosure model = new ModelBoxOfEternalClosure();
            ResourceLocation texture = new ResourceLocation("evilcraft", "textures/models/box.png");
            ClientProxy.TILE_ENTITY_RENDERERS.put(TileBoxOfEternalClosure.class, new RenderTileEntityBoxOfEternalClosure(model, texture));
            ClientProxy.ITEM_RENDERERS.put(Item.func_150898_a((Block)BoxOfEternalClosure.getInstance()), new RenderItemBoxOfEternalClosure(model, texture));
        }
        ItemStack spiritStack = new ItemStack(Item.func_150898_a((Block)BoxOfEternalClosure.getInstance()), 1, 0);
        ItemStack swarmStack = spiritStack.func_77946_l();
        BoxOfEternalClosure.setVengeanceSwarmContent(swarmStack);
        for (String chestCategory : MinecraftHelpers.CHESTGENCATEGORIES) {
            for (UUID playerId : BoxCookTickAction.PLAYERDROP_OVERRIDES.keySet()) {
                ItemStack playerStack = spiritStack.func_77946_l();
                BoxOfEternalClosure.setPlayerContent(playerStack, playerId);
                ChestGenHooks.getInfo((String)chestCategory).addItem(new WeightedRandomChestContent(playerStack, 1, 1, 1));
            }
            ChestGenHooks.getInfo((String)chestCategory).addItem(new WeightedRandomChestContent(swarmStack, 1, 1, 3));
        }
    }

    @Override
    public boolean isHardDisabled() {
        return !Configs.isEnabled(VengeanceSpiritConfig.class);
    }
}

