/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.block.SpiritFurnace;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.Size;
import evilcraft.core.algorithm.Wrapper;
import evilcraft.core.block.CubeDetector;
import evilcraft.core.config.configurable.ConfigurableBlock;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.tileentity.TileSpiritFurnace;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DarkBloodBrick
extends ConfigurableBlock
implements CubeDetector.IDetectionListener {
    private static DarkBloodBrick _instance = null;
    private IIcon blockIconInactive;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new DarkBloodBrick(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static DarkBloodBrick getInstance() {
        return _instance;
    }

    private DarkBloodBrick(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149672_a(field_149769_e);
        this.setHarvestLevel("pickaxe", 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.blockIconInactive = iconRegister.func_94245_a(this.func_149641_N() + "_inactive");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return this.blockIconInactive;
        }
        return super.func_149691_a(side, meta);
    }

    public boolean canCreatureSpawn(EnumCreatureType creatureType, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    private void triggerDetector(World world, int x, int y, int z, boolean valid) {
        TileSpiritFurnace.detector.detect(world, new Location(x, y, z), valid, true);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.triggerDetector(world, x, y, z, true);
        world.func_147453_f(x, y, z, (Block)this);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        if (meta == 1) {
            this.triggerDetector(world, x, y, z, false);
        }
        super.func_149725_f(world, x, y, z, meta);
    }

    @Override
    public void onDetect(World world, ILocation location, Size size, boolean valid, ILocation originCorner) {
        Block block = LocationHelpers.getBlock(world, location);
        if (block == this) {
            TileSpiritFurnace.detectStructure(world, location, size, valid);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float posX, float posY, float posZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 1) {
            final Wrapper tileLocationWrapper = new Wrapper();
            TileSpiritFurnace.detector.detect(world, new Location(x, y, z), true, new CubeDetector.IValidationAction(){

                @Override
                public void onValidate(ILocation location, Block block) {
                    if (block == SpiritFurnace.getInstance()) {
                        tileLocationWrapper.set(location);
                    }
                }
            }, false);
            ILocation tileLocation = (ILocation)tileLocationWrapper.get();
            if (tileLocation != null) {
                int[] c = tileLocation.getCoordinates();
                LocationHelpers.getBlock(world, tileLocation).func_149727_a(world, c[0], c[1], c[2], player, side, posX, posY, posZ);
                return true;
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, posX, posY, posZ);
    }
}

