/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Achievements;
import evilcraft.Configs;
import evilcraft.block.DarkOreConfig;
import evilcraft.core.IInformationProvider;
import evilcraft.core.config.configurable.ConfigurableBlock;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.item.DarkGem;
import evilcraft.item.DarkGemConfig;
import evilcraft.item.DarkGemCrushedConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class DarkOre
extends ConfigurableBlock
implements IInformationProvider {
    private static DarkOre _instance = null;
    private static final int MINIMUM_DROPS = 1;
    private static final int INCREASE_DROPS = 3;
    private static final int INCREASE_XP = 5;
    private static final int CRUSHEDCHANCE = 4;
    private static final int GLOWINGMETA = 1;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new DarkOre(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static DarkOre getInstance() {
        return _instance;
    }

    private DarkOre(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.0f);
        this.func_149672_a(field_149769_e);
        this.setHarvestLevel("pickaxe", 2);
    }

    public Item func_149650_a(int meta, Random random, int zero) {
        if (Configs.isEnabled(DarkGemConfig.class)) {
            return DarkGem.getInstance();
        }
        return null;
    }

    public int func_149679_a(int amount, Random random) {
        return this.func_149745_a(random) + random.nextInt(amount / 4 + 1);
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float dropchance, int fortune) {
        super.func_149690_a(world, x, y, z, meta, dropchance, fortune);
        if (this.func_149650_a(meta, world.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            int xp = 1 + world.field_73012_v.nextInt(5);
            this.func_149657_c(world, x, y, z, xp);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList drops = super.getDrops(world, x, y, z, metadata, fortune);
        if ((fortune > 0 || world.field_73012_v.nextInt(4) == 0) && Configs.isEnabled(DarkGemCrushedConfig.class)) {
            drops.add(new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), world.field_73012_v.nextInt(fortune / 3 + 1) + 1));
        }
        return drops;
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)_instance);
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        player.func_71064_a((StatBase)Achievements.FIRST_AGE, 1);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.glow(world, x, y, z);
        super.func_149699_a(world, x, y, z, player);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.glow(world, x, y, z);
        super.func_149724_b(world, x, y, z, entity);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float motionX, float motionY, float motionZ) {
        this.glow(world, x, y, z);
        return super.func_149727_a(world, x, y, z, player, meta, motionX, motionY, motionZ);
    }

    private boolean isGlowing(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 1;
    }

    private void glow(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            return;
        }
        this.sparkle(world, x, y, z);
        if (!this.isGlowing(world, x, y, z)) {
            world.func_72921_c(x, y, z, 1, 2);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.isGlowing(world, x, y, z)) {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.isGlowing(world, x, y, z)) {
            this.sparkle(world, x, y, z);
        }
    }

    private void sparkle(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            return;
        }
        Random random = world.field_73012_v;
        double offset = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double sparkX = (float)x + random.nextFloat();
            double sparkY = (float)y + random.nextFloat();
            double sparkZ = (float)z + random.nextFloat();
            if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149637_q()) {
                sparkY = (double)(y + 1) + offset;
            }
            if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149637_q()) {
                sparkY = (double)(y + 0) - offset;
            }
            if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149637_q()) {
                sparkZ = (double)(z + 1) + offset;
            }
            if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149637_q()) {
                sparkZ = (double)(z + 0) - offset;
            }
            if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149637_q()) {
                sparkX = (double)(x + 1) + offset;
            }
            if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149637_q()) {
                sparkX = (double)(x + 0) - offset;
            }
            if (!(sparkX < (double)x || sparkX > (double)(x + 1) || sparkY < 0.0 || sparkY > (double)(y + 1) || sparkZ < (double)z) && !(sparkZ > (double)(z + 1))) continue;
            world.func_72869_a("smoke", sparkX, sparkY, sparkZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_149700_E() {
        return true;
    }

    @Override
    public int getRenderPasses() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta, int renderPass) {
        if (renderPass == 1) {
            return this.field_149761_L;
        }
        return Blocks.field_150348_b.func_149691_a(side, meta);
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return IInformationProvider.INFO_PREFIX + L10NHelpers.localize(this.func_149739_a() + ".info.custom", DarkOreConfig.startY, DarkOreConfig.endY);
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }
}

