/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Configs;
import evilcraft.block.DarkTankConfig;
import evilcraft.client.render.block.RenderDarkTank;
import evilcraft.core.IInformationProvider;
import evilcraft.core.block.IBlockTank;
import evilcraft.core.block.component.BlockTankComponent;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.fluid.Blood;
import evilcraft.fluid.BloodConfig;
import evilcraft.tileentity.TileDarkTank;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class DarkTank
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockTank {
    private static final String NBT_TAG_CAPACITY = "tankCapacity";
    public static final int META_DRAINING = 1;
    private static DarkTank _instance = null;
    private BlockTankComponent<DarkTank> tankComponent = new BlockTankComponent<DarkTank>(this);
    protected IIcon sideIcon;
    protected IIcon topIcon;
    protected IIcon sideIconActive;
    protected IIcon topIconActive;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new DarkTank(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static DarkTank getInstance() {
        return _instance;
    }

    private DarkTank(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151592_s, TileDarkTank.class);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149778_k);
    }

    public void func_149683_g() {
        this.func_149676_a(0.125f, 0.001f, 0.125f, 0.875f, 0.999f, 0.875f);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149683_g();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB area, List list, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, area, list, entity);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TankInventoryTileEntity tile = (TankInventoryTileEntity)world.func_147438_o(x, y, z);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.sideIconActive = iconRegister.func_94245_a(this.func_149641_N() + "_side_active");
        this.topIconActive = iconRegister.func_94245_a(this.func_149641_N() + "_top_active");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            return meta == 1 ? this.topIconActive : this.topIcon;
        }
        return meta == 1 ? this.sideIconActive : this.sideIcon;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public int func_149645_b() {
        return RenderDarkTank.ID;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float motionX, float motionY, float motionZ) {
        if (this.tankComponent.onBlockActivatedTank(world, x, y, z, player, side, motionX, motionY, motionZ)) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        world.func_72921_c(x, y, z, 1 - meta, 2);
        return true;
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return this.tankComponent.getInfoTank(itemStack);
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    @Override
    public String getTankNBTName() {
        return "darkTank";
    }

    @Override
    public int getTankCapacity(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b(NBT_TAG_CAPACITY)) {
            return 16000;
        }
        return tag.func_74762_e(NBT_TAG_CAPACITY);
    }

    @Override
    public void setTankCapacity(ItemStack itemStack, int capacity) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        this.setTankCapacity(tag, capacity);
    }

    @Override
    public void setTankCapacity(NBTTagCompound tag, int capacity) {
        tag.func_74768_a(NBT_TAG_CAPACITY, capacity);
    }

    @Override
    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
        super.writeAdditionalInfo(tile, tag);
        this.tankComponent.writeAdditionalInfo(tile, tag);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileDarkTank tank;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileDarkTank && (tank = (TileDarkTank)tile).getTank().getFluidType() != null) {
            return (int)Math.min(15.0, tank.getFillRatio() * (double)tank.getTank().getFluidType().getLuminosity() * 15.0);
        }
        return 0;
    }

    @Override
    public int getMaxCapacity() {
        return DarkTankConfig.maxTankSize;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_77964_b(1 - activated.func_77960_j());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, World world, Entity entity) {
        return itemStack.func_77960_j() == 1;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack(item);
        int capacity = capacityOriginal = 16000;
        do {
            this.setTankCapacity(itemStack, capacity);
            list.add(itemStack.func_77946_l());
            if (Configs.isEnabled(BloodConfig.class)) {
                ItemStack itemStackFilled = itemStack.func_77946_l();
                IFluidContainerItem container = (IFluidContainerItem)itemStackFilled.func_77973_b();
                container.fill(itemStackFilled, new FluidStack((Fluid)Blood.getInstance(), capacity), true);
                list.add(itemStackFilled);
            }
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(DarkTankConfig.maxTankCreativeSize, DarkTankConfig.maxTankSize) && capacity > lastCapacity);
        if (DarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == null || fluid == Blood.getInstance()) continue;
                try {
                    ItemStack itemStackFilled = itemStack.func_77946_l();
                    this.setTankCapacity(itemStackFilled, capacityOriginal);
                    IFluidContainerItem container = (IFluidContainerItem)itemStackFilled.func_77973_b();
                    container.fill(itemStackFilled, new FluidStack(fluid, capacityOriginal), true);
                    list.add(itemStackFilled);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }
}

