/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.api.RegistryManager;
import evilcraft.api.recipes.custom.IMachine;
import evilcraft.api.recipes.custom.IRecipeRegistry;
import evilcraft.api.recipes.custom.ISuperRecipeRegistry;
import evilcraft.client.render.block.RenderEnvironmentalAccumulator;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.item.EnvironmentalAccumulationCoreConfig;
import evilcraft.tileentity.TileEnvironmentalAccumulator;
import evilcraft.world.gen.DarkTempleGenerator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnvironmentalAccumulator
extends ConfigurableBlockContainer
implements IMachine<EnvironmentalAccumulator, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> {
    private static EnvironmentalAccumulator _instance = null;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PROCESSING_ITEM = 1;
    public static final int STATE_COOLING_DOWN = 2;
    public static final int STATE_FINISHED_PROCESSING_ITEM = 3;
    private IIcon sideIcon;
    private IIcon bottomIcon;
    private IIcon topIcon;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new EnvironmentalAccumulator(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static EnvironmentalAccumulator getInstance() {
        return _instance;
    }

    private EnvironmentalAccumulator(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileEnvironmentalAccumulator.class);
        this.setRotatable(true);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000000.0f);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return RenderEnvironmentalAccumulator.ID;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.topIcon;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.bottomIcon;
        }
        return this.sideIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.bottomIcon = iconRegister.func_94245_a(this.func_149641_N() + "_bottom");
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top");
    }

    public Item func_149650_a(int meta, Random random, int zero) {
        return EnvironmentalAccumulationCoreConfig._instance.getItemInstance();
    }

    @Override
    public IRecipeRegistry<EnvironmentalAccumulator, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipeRegistry() {
        return RegistryManager.getRegistry(ISuperRecipeRegistry.class).getRecipeRegistry(this);
    }

    @Override
    protected void onPreBlockDestroyed(World world, int x, int y, int z) {
        ILocation closest;
        if (!world.field_72995_K && (closest = DarkTempleGenerator.getClosestForCoords(world, x, z)) != null) {
            DarkTempleGenerator.getCachedData(world).addFailedLocation(closest.getCoordinates()[0] / 16, closest.getCoordinates()[2] / 16);
        }
        super.onPreBlockDestroyed(world, x, y, z);
    }
}

