/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.render.block.RenderPurifier;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.item.BucketBloodConfig;
import evilcraft.tileentity.TilePurifier;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Purifier
extends ConfigurableBlockContainer {
    private static Purifier _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon innerIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new Purifier(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static Purifier getInstance() {
        return _instance;
    }

    private Purifier(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TilePurifier.class);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float motionX, float motionY, float motionZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        TilePurifier tile = (TilePurifier)world.func_147438_o(x, y, z);
        if (tile != null) {
            if (itemStack == null && tile.getPurifyItem() != null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tile.getPurifyItem());
                tile.setPurifyItem(null);
            } else if (itemStack == null && tile.getAdditionalItem() != null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tile.getAdditionalItem());
                tile.setAdditionalItem(null);
            } else if (itemStack != null && itemStack.func_77973_b() instanceof ItemBucket) {
                FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                if (fluidStack != null && tile.getTank().canTankAccept(fluidStack.getFluid()) && tile.getTank().canCompletelyFill(fluidStack) && itemStack.func_77973_b() != Items.field_151133_ar) {
                    tile.getTank().fill(fluidStack, true);
                    tile.sendUpdate();
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                    }
                    return true;
                }
                if (itemStack.func_77973_b() == Items.field_151133_ar) {
                    int buckets = tile.getBucketsFloored();
                    if (buckets > 0) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(BucketBloodConfig._instance.getItemInstance()));
                        }
                        tile.setBuckets(buckets - 1, tile.getBucketsRest());
                    }
                    return true;
                }
            } else {
                if (itemStack != null && tile.getActions().isItemValidForAdditionalSlot(itemStack) && tile.getAdditionalItem() == null) {
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = 1;
                    tile.setAdditionalItem(copy);
                    --itemStack.field_77994_a;
                    return true;
                }
                if (itemStack != null && tile.getActions().isItemValidForMainSlot(itemStack) && tile.getPurifyItem() == null) {
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = 1;
                    tile.setPurifyItem(copy);
                    --player.field_71071_by.func_70448_g().field_77994_a;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : (side == 0 ? this.bottomIcon : this.field_149761_L);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.innerIcon = iconRegister.func_94245_a(this.func_149641_N() + "_inner");
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.bottomIcon = iconRegister.func_94245_a(this.func_149641_N() + "_bottom");
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N() + "_side");
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB area, List collisionBoxes, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f);
        super.func_149743_a(world, x, y, z, area, collisionBoxes, entity);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, area, collisionBoxes, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.func_149743_a(world, x, y, z, area, collisionBoxes, entity);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, area, collisionBoxes, entity);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, area, collisionBoxes, entity);
        this.func_149683_g();
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getPurifierIcon(String icon) {
        return icon.equals("inner") ? Purifier._instance.innerIcon : (icon.equals("bottom") ? Purifier._instance.bottomIcon : null);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return RenderPurifier.ID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z);
    }
}

